package com.clx.performance.constant;

/**
 * @Author: aiqingguo
 * @Description: 结算-mq
 * @Date: 2023-10-19 15:13:06
 * @Version: 1.0
 */
public class RabbitKeySettlementConstants {

    private static final String PREFIX = "clx-performance.settlement.";
    private static final String EXCHANGE = ".exchange";
    private static final String QUEUE = ".queue";
    private static final String QUEUE_ROUTING_KEY = ".routing.key";
    private static final String DELAY_QUEUE = ".delay.queue";
    private static final String DELAY_ROUTING_KEY = ".delay.routing.key";
    private static final String DEAD_QUEUE = ".dead.queue";
    private static final String DEAD_ROUTING_KEY = ".dead.routing.key";

    private RabbitKeySettlementConstants() {
    }

    /**
     * 缺省交换机
     */
    public static final String DEFAULT_EXCHANGE = PREFIX +"default"+EXCHANGE;

    /**
     * 缺省延迟队列
     */
    public static final String DEFAULT_DELAY_QUEUE = PREFIX +"default"+DELAY_QUEUE;
    public static final String DEFAULT_DELAY_ROUTING_KEY = PREFIX +"default"+DELAY_ROUTING_KEY;
    public static final String DEFAULT_DEAD_QUEUE = PREFIX +"default"+DEAD_QUEUE;
    public static final String DEFAULT_DEAD_ROUTING_KEY = PREFIX +"default"+DEAD_ROUTING_KEY;

    /**
     * 新增计费单
     */
    public static final String SETTLEMENT_DETAIL_ADD_QUEUE = PREFIX +"settlementDetail.add"+QUEUE;
    public static final String SETTLEMENT_DETAIL_ADD_ROUTING_KEY = PREFIX +"settlementDetail.add"+QUEUE_ROUTING_KEY;

    /**
     * 同步开票标识
     */
    public static final String SETTLEMENT_DETAIL_INVOICE_TYPE_SYC_QUEUE = PREFIX +"settlementDetailInvoiceType.sync"+QUEUE;
    public static final String SETTLEMENT_DETAIL_INVOICE_TYPE_SYC_ROUTING_KEY = PREFIX +"settlementDetailInvoiceType.sync"+QUEUE_ROUTING_KEY;

}
