package com.clx.performance.service.impl.breakcontract;

import com.alibaba.fastjson.JSON;
import com.clx.performance.config.BreakContractConfig;
import com.clx.performance.dao.breakcontract.BreakContractOwnerRuleDao;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.extranal.document.DocumentService;
import com.clx.performance.model.breakcontract.BreakContractOwnerRule;
import com.clx.performance.param.mq.BreakContractOwnerRuleAddMqParam;
import com.clx.performance.service.breakcontract.BreakContractMqHandlerService;
import com.msl.document.api.vo.ContractEvidenceRecordVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Map;

@Slf4j
@Service
public class BreakContractMqHandlerServiceImpl implements BreakContractMqHandlerService {

    @Autowired
    private BreakContractOwnerRuleDao breakContractOwnerRuleDao;

    @Autowired
    private DocumentService documentService;

    @Autowired
    private BreakContractConfig breakContractConfig;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void ownerRuleAdd(BreakContractOwnerRuleAddMqParam mq) {

        BreakContractOwnerRule rule = breakContractOwnerRuleDao.getEntityByKey(mq.getRuleId()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);

        Map<String,String> map = JSON.parseObject(rule.getRuleJson(), Map.class);

        // 创建合同
        Long contractNo = documentService.createContract(breakContractConfig.getTemplateNo(), map);
        ContractEvidenceRecordVo contract = documentService.getContractInfo(contractNo);

        // 更新违约规则文档
        rule.setFile(contract.getFileUrl());
        breakContractOwnerRuleDao.updateFile(rule);

    }
}
