package com.clx.performance.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.clx.order.enums.OrderEnum;
import com.clx.order.feign.OrderFeign;
import com.clx.order.param.feign.RollbackOrderWeightParam;
import com.clx.order.vo.feign.FeignOrderVO;
import com.clx.performance.constant.RabbitKeyConstants;
import com.clx.performance.dao.OrderChildDao;
import com.clx.performance.dao.OrderGoodsDao;
import com.clx.performance.enums.OrderChildEnum;
import com.clx.performance.enums.OrderGoodsStatusEnum;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.enums.TruckDemandEnum;
import com.clx.performance.model.OrderChild;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.param.mq.OrderCancelMqParam;
import com.clx.performance.param.pc.OrderCancelParam;
import com.clx.performance.service.OrderCancelService;
import com.msl.common.exception.ServiceSystemException;
import com.msl.common.result.Result;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilder;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Slf4j
@Service
@AllArgsConstructor
public class OrderCancelServiceImpl implements OrderCancelService {


    private final OrderFeign orderFeign;

    private final OrderChildDao orderChildDao;

    private final OrderGoodsDao orderGoodsDao;

    private final RabbitTemplate rabbitTemplate;

//
//    @Override
//    @Transactional(rollbackFor = Exception.class)
//    public void platformCancelOrderPre(String orderNo) {
////        FeignOrderVO orderInfoFeign = orderFeign.getOrderInfoFeign(orderNo);
////        BigDecimal orderTransportWeight = new BigDecimal(orderInfoFeign.getTransportWeight());
//
//        List<OrderGoods> orderGoodsList = orderGoodsDao.getOrderGoodsListByOrderNo(orderNo);
//        if (CollectionUtil.isEmpty(orderGoodsList)) {
//            //未产生货单
//            Result<Object> result = orderFeign.updateOrderStatusByOrderNo(orderNo, OrderEnum.Status.CANCELED.getCode());
//            if (!result.succeed()) {
//                throw new RuntimeException("货主取消订单失败,原因：远程调用取消订单失败");
//            }
//            log.info("执行平台订单取消前置：更改相关状态完毕，开始执行吨数回填，发送MQ消息,订单No {}", orderNo);
//            OrderCancelMqParam mqParam = new OrderCancelMqParam();
//            mqParam.setType("1");
//            mqParam.setOrderNo(orderNo);
//            Message message = MessageBuilder.withBody(JSONUtil.parse(mqParam).toString().getBytes()).build();
//            rabbitTemplate.send(
//                    RabbitKeyConstants.ORDER_CANCEL_EXCHANGE, RabbitKeyConstants.ORDER_CANCEL_ROUTE_KEY, message
//            );
//            return;
//        }
//
//        List<OrderChild> orderChildrenList = orderChildDao.selectResidueWeight(orderNo, null);
//
//        if (CollectionUtil.isEmpty(orderChildrenList)) {
//            //说明此刻未产生运单
//            Result<Object> result = orderFeign.updateOrderStatusByOrderNo(orderNo, OrderEnum.Status.CANCELED.getCode());
//            if (!result.succeed()) {
//                throw new RuntimeException("货主取消订单失败,原因：远程调用取消订单失败");
//            }
//
//            for (OrderGoods orderGoods : orderGoodsList) {
//                OrderGoods update = new OrderGoods();
//                update.setId(orderGoods.getId());
//                update.setOrderGoodsStatus(OrderGoodsStatusEnum.Status.CANCEL.getCode());
//                orderGoodsDao.updateEntityByKey(update);
//            }
//
//        } else {
//
//            Map<String, List<OrderChild>> orderChildMap = orderChildrenList.stream()
//                    .collect(Collectors.groupingBy(OrderChild::getOrderGoodsNo));
//
//            for (OrderGoods orderGoods : orderGoodsList) {
//                OrderGoods update = new OrderGoods();
//                update.setId(orderGoods.getId());
//                List<OrderChild> orderChildren = orderChildMap.get(orderGoods.getOrderGoodsNo());
//                if (CollectionUtil.isEmpty(orderChildren)) {
//                    //没有运单，直接是取消
//                    update.setOrderGoodsStatus(OrderGoodsStatusEnum.Status.CANCEL.getCode());
//                } else {
//                    if (orderGoods.getResidueTransportWeight().compareTo(BigDecimal.ZERO) != 0) {
//                        //货单还有余量，是已完结
//                        update.setOrderGoodsStatus(OrderGoodsStatusEnum.Status.COMPLETED.getCode());
//                    } else {
//                        List<OrderChild> orderChildrenListComplete = orderChildDao.selectResidueWeight(orderNo, OrderChildEnum.Status.COMPLETE.getCode());
//                        if (CollectionUtil.isNotEmpty(orderChildrenListComplete)) {
//                            Map<String, List<OrderChild>> orderChildCompleteMap = orderChildrenListComplete.stream()
//                                    .collect(Collectors.groupingBy(OrderChild::getOrderGoodsNo));
//                            //没有余量,需要判断已完成的运单量是不等于货单的全部提取量，等于则是已完成，否则是已完结
//                            List<OrderChild> childList = orderChildCompleteMap.get(orderGoods.getOrderGoodsNo());
//                            BigDecimal reduce = childList.stream().map(OrderChild::getWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
//                            if (reduce.compareTo(orderGoods.getExtractWeight()) == 0) {
//                                update.setOrderGoodsStatus(OrderGoodsStatusEnum.Status.SUCCESS.getCode());
//                            } else {
//                                update.setOrderGoodsStatus(OrderGoodsStatusEnum.Status.COMPLETED.getCode());
//                            }
//                        }
//
//                    }
//                }
//                orderGoodsDao.updateEntityByKey(update);
//            }
//            Result<Object> result = orderFeign.updateOrderStatusByOrderNo(orderNo, OrderEnum.Status.COMPLETED.getCode());
//            if (!result.succeed()) {
//                throw new RuntimeException("货主取消订单失败,原因：远程调用取消订单失败");
//            }
//        }
//
//        log.info("执行平台订单取消前置：更改相关状态完毕，开始执行吨数回填，发送MQ消息,订单No {}", orderNo);
//        OrderCancelMqParam mqParam = new OrderCancelMqParam();
//        mqParam.setType("1");
//        mqParam.setOrderNo(orderNo);
//        Message message = MessageBuilder.withBody(JSONUtil.parse(mqParam).toString().getBytes()).build();
//        rabbitTemplate.send(
//                RabbitKeyConstants.ORDER_CANCEL_EXCHANGE, RabbitKeyConstants.ORDER_CANCEL_ROUTE_KEY, message
//        );
//
//    }
//
//    @Override
//    @Transactional(rollbackFor = Exception.class)
//    public void platformCancelOrder(String orderNo) {
//        log.info("开始执行平台订单取消吨数回填");
//        FeignOrderVO orderInfoFeignVO = orderFeign.getOrderInfoFeign(orderNo);
//
//        List<OrderGoods> orderGoodsList = orderGoodsDao.getOrderGoodsListByOrderNo(orderNo);
//        Map<Integer, BigDecimal> truckDemandMap = new HashMap<>();
//        truckDemandMap.put(TruckDemandEnum.TruckType.PLATFORM_CAR.getCode(), BigDecimal.ZERO);
//        truckDemandMap.put(TruckDemandEnum.TruckType.OWNER_CAR.getCode(), BigDecimal.ZERO);
//
//        //非部分平台车辆拉运
//        if (!TruckDemandEnum.TruckType.PLATFORM_ANY_CAR.getCode().equals(orderInfoFeignVO.getTruckDemand())) {
//            if (OrderEnum.Status.COMPLETED.getCode().equals(orderInfoFeignVO.getOrderStatus())) {
//                //已完结
//                List<OrderChild> orderChildrenList = orderChildDao.selectResidueWeight(orderNo, OrderChildEnum.Status.ARRIVE_SEND.getCode());
//
//                for (OrderChild orderChild : orderChildrenList) {
//                    OrderChild update = new OrderChild();
//                    update.setId(orderChild.getId());
//                    update.setStatus(OrderChildEnum.Status.PLATFORM_CANCEL.getCode());
//                    //TODO 补充批量更新接口  关闭运单状态
//                    orderChildDao.updateEntityByKey(update);
//                }
//                Map<String, List<OrderGoods>> orderGoodsMap = orderGoodsList.stream()
//                        .collect(Collectors.groupingBy(OrderGoods::getOrderGoodsNo));
//
//                Map<String, List<OrderChild>> orderChildMap = orderChildrenList.stream()
//                        .collect(Collectors.groupingBy(OrderChild::getOrderGoodsNo));
//
//                for (Map.Entry<String, List<OrderGoods>> entry : orderGoodsMap.entrySet()) {
//                    String orderGoodsNo = entry.getKey();
//                    OrderGoods orderGoods = entry.getValue().get(0);
//                    List<OrderChild> orderChildren = orderChildMap.get(orderGoodsNo);
//                    BigDecimal sum = BigDecimal.ZERO;
//                    if (CollectionUtil.isNotEmpty(orderChildren)) {
//                        sum = orderChildren.stream()
//                                .map(OrderChild::getWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
//                    }
//                    truckDemandMap.put(orderGoods.getTruckDemand(),
//                            truckDemandMap.get(orderGoods.getTruckDemand())
//                                    .add(orderGoods.getResidueTransportWeight().add(sum)));
//
//                    OrderGoods update = new OrderGoods();
//                    update.setId(orderGoods.getId());
//                    //TODO 补充批量更新接口  关闭货单状态  注意判断货单是已完结还是已完成
//                    update.setResidueTransportWeight(BigDecimal.ZERO);
////                    update.setOrderGoodsStatus(OrderGoodsStatusEnum.Status.COMPLETED.getCode());
//                    orderGoodsDao.updateEntityByKey(update);
//                }
//
//            } else if (OrderEnum.Status.CANCELED.getCode().equals(orderInfoFeignVO.getOrderStatus())) {
//                //已取消
//                for (OrderGoods orderGoods : orderGoodsList) {
//                    truckDemandMap.put(orderGoods.getTruckDemand(),
//                            truckDemandMap.get(orderGoods.getTruckDemand())
//                                    .add(orderGoods.getResidueTransportWeight()));
//                    OrderGoods update = new OrderGoods();
//                    update.setId(orderGoods.getId());
//                    //TODO 补充批量更新接口  关闭货单状态
//                    update.setResidueTransportWeight(BigDecimal.ZERO);
////                    update.setOrderGoodsStatus(OrderGoodsStatusEnum.Status.CANCEL.getCode());
//                    orderGoodsDao.updateEntityByKey(update);
//                }
//            }
//
//            Integer truckDemand = orderInfoFeignVO.getTruckDemand();
//            BigDecimal residueWeight = truckDemandMap.get(truckDemand);
//            if (residueWeight.compareTo(BigDecimal.ZERO) == 0) {
//                log.info("当前订单对应的货单无需吨数回填,订单编号{}", orderNo);
//                return;
//            }
//
//            //归还吨数
//            RollbackOrderWeightParam param = new RollbackOrderWeightParam();
//            param.setOrderNo(orderInfoFeignVO.getOrderNo());
//            if (truckDemand.equals(TruckDemandEnum.TruckType.PLATFORM_CAR.getCode())) {
//                param.setResidueWeight(residueWeight);
//                param.setOwnResidueCarryWeight(BigDecimal.ZERO);
//                param.setPlatformResidueCarryWeight(residueWeight);
//            }
//            if (truckDemand.equals(TruckDemandEnum.TruckType.OWNER_CAR.getCode())) {
//                param.setResidueWeight(residueWeight);
//                param.setOwnResidueCarryWeight(residueWeight);
//                param.setPlatformResidueCarryWeight(BigDecimal.ZERO);
//            }
//            orderFeign.rollbackOrderWeight(param);
//
//        } else {
//            Map<Integer, BigDecimal> vehicleUsageMap = new HashMap<>();
//            if (OrderEnum.Status.COMPLETED.getCode().equals(orderInfoFeignVO.getOrderStatus())) {
//                //已完结
//                List<OrderChild> orderChildrenList = orderChildDao.selectResidueWeight(orderNo, OrderChildEnum.Status.ARRIVE_SEND.getCode());
//
//                for (OrderChild orderChild : orderChildrenList) {
//                    OrderChild update = new OrderChild();
//                    update.setId(orderChild.getId());
//                    update.setStatus(OrderChildEnum.Status.PLATFORM_CANCEL.getCode());
//                    //TODO 补充批量更新接口  关闭运单状态
//                    orderChildDao.updateEntityByKey(update);
//                }
//                //货单
//                Map<String, List<OrderGoods>> orderGoodsMap = orderGoodsList.stream()
//                        .collect(Collectors.groupingBy(OrderGoods::getOrderGoodsNo));
//                //运单
//                Map<String, List<OrderChild>> orderChildMap = orderChildrenList.stream()
//                        .collect(Collectors.groupingBy(OrderChild::getOrderGoodsNo));
//
//
//                for (Map.Entry<String, List<OrderGoods>> entry : orderGoodsMap.entrySet()) {
//                    String orderGoodsNo = entry.getKey();
//                    OrderGoods orderGoods = entry.getValue().get(0);
//
//                    BigDecimal sum = BigDecimal.ZERO;
//                    if (CollectionUtil.isNotEmpty(orderChildMap.get(orderGoodsNo))) {
//                        sum = orderChildMap.get(orderGoodsNo).stream()
//                                .map(OrderChild::getWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
//                    }
//                    vehicleUsageMap.put(orderGoods.getVehicleUsage(),
//                            vehicleUsageMap.get(orderGoods.getVehicleUsage())
//                                    .add(orderGoods.getResidueTransportWeight().add(sum)));
//                    OrderGoods update = new OrderGoods();
//                    update.setId(orderGoods.getId());
//                    //TODO 补充批量更新接口  关闭货单状态
//                    update.setResidueTransportWeight(BigDecimal.ZERO);
//                    //update.setOrderGoodsStatus(OrderGoodsStatusEnum.Status.COMPLETED.getCode());
//                    orderGoodsDao.updateEntityByKey(update);
//
//                }
//
//            } else if (OrderEnum.Status.CANCELED.getCode().equals(orderInfoFeignVO.getOrderStatus())) {
//                //已取消
//                for (OrderGoods orderGoods : orderGoodsList) {
//                    vehicleUsageMap.put(orderGoods.getVehicleUsage(),
//                            vehicleUsageMap.get(orderGoods.getVehicleUsage())
//                                    .add(orderGoods.getResidueTransportWeight()));
//                    OrderGoods update = new OrderGoods();
//                    update.setId(orderGoods.getId());
//                    //TODO 补充批量更新接口  关闭货单状态
//                    update.setResidueTransportWeight(BigDecimal.ZERO);
//                    //update.setOrderGoodsStatus(OrderGoodsStatusEnum.Status.COMPLETED.getCode());
//                    orderGoodsDao.updateEntityByKey(update);
//                }
//            }
//
//            //归还吨数
//            BigDecimal platformResidueSum = vehicleUsageMap.get(1);
//            BigDecimal ownResidueSum = vehicleUsageMap.get(2);
//            BigDecimal residueSum = platformResidueSum.add(ownResidueSum);
//            RollbackOrderWeightParam param = new RollbackOrderWeightParam();
//            param.setOrderNo(orderInfoFeignVO.getOrderNo());
//            param.setResidueWeight(residueSum);
//            param.setPlatformResidueCarryWeight(platformResidueSum);
//            param.setOwnResidueCarryWeight(ownResidueSum);
//            orderFeign.rollbackOrderWeight(param);
//        }
//
//
//    }
//
//
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void ownerCancelOrderPre(String orderNo) {
        //FeignOrderVO orderInfoFeign = orderFeign.getOrderInfoFeign(orderNo);

        List<OrderGoods> orderGoodsList = orderGoodsDao.getOrderGoodsListByOrderNo(orderNo);
        if (CollectionUtil.isEmpty(orderGoodsList)) {
            //未产生货单
            Result<Object> result = orderFeign.updateOrderStatusByOrderNo(orderNo, OrderEnum.Status.CANCELED.getCode());
            if (!result.succeed()) {
                throw new RuntimeException("货主取消订单失败,原因：远程调用取消订单失败");
            }
            this.ownerCancelOrder(orderNo);

//            log.info("执行货主订单取消前置：更改相关状态完毕，开始执行吨数回填，发送MQ消息,订单No {}", orderNo);
//            OrderCancelMqParam mqParam = new OrderCancelMqParam();
//            mqParam.setType("2");
//            mqParam.setOrderNo(orderNo);
//            Message message = MessageBuilder.withBody(JSONUtil.parse(mqParam).toString().getBytes()).build();
//            rabbitTemplate.send(
//                    RabbitKeyConstants.ORDER_CANCEL_EXCHANGE, RabbitKeyConstants.ORDER_CANCEL_ROUTE_KEY, message
//            );
            return;
        }

        List<OrderChild> orderChildrenList = orderChildDao.selectResidueWeight(orderNo, null);

        if (CollectionUtil.isEmpty(orderChildrenList)) {
            //说明此刻未产生运单
            Result<Object> result = orderFeign.updateOrderStatusByOrderNo(orderNo, OrderEnum.Status.CANCELED.getCode());
            if (!result.succeed()) {
                throw new RuntimeException("货主取消订单失败,原因：远程调用取消订单失败");
            }

            for (OrderGoods orderGoods : orderGoodsList) {
                OrderGoods update = new OrderGoods();
                update.setId(orderGoods.getId());
                update.setOrderGoodsStatus(OrderGoodsStatusEnum.Status.CANCEL.getCode());
                orderGoodsDao.updateEntityByKey(update);
            }

        } else {

            Map<String, List<OrderChild>> orderChildMap = orderChildrenList.stream()
                    .collect(Collectors.groupingBy(OrderChild::getOrderGoodsNo));

            for (OrderGoods orderGoods : orderGoodsList) {
                OrderGoods update = new OrderGoods();
                update.setId(orderGoods.getId());
                List<OrderChild> orderChildren = orderChildMap.get(orderGoods.getOrderGoodsNo());
                if (CollectionUtil.isEmpty(orderChildren)) {
                    //没有运单，直接是取消
                    update.setOrderGoodsStatus(OrderGoodsStatusEnum.Status.CANCEL.getCode());
                } else {
                    if (orderGoods.getResidueTransportWeight().compareTo(BigDecimal.ZERO) != 0) {
                        //货单还有余量，是已完结
                        update.setOrderGoodsStatus(OrderGoodsStatusEnum.Status.COMPLETED.getCode());
                    } else {
                        List<OrderChild> orderChildrenListComplete = orderChildDao.selectOrderChildListByOrderGoodsNoAndStatusGE(orderGoods.getOrderGoodsNo(), OrderChildEnum.Status.ARRIVE_SEND.getCode());
                        if (CollectionUtil.isNotEmpty(orderChildrenListComplete)) {
                            //没有余量,需要判断已完成的运单量是不等于货单的全部提取量，等于则是已完成，否则是已完结
                            BigDecimal reduce = orderChildrenListComplete.stream().map(OrderChild::getWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
                            if (reduce.compareTo(orderGoods.getExtractWeight()) == 0) {
                                update.setOrderGoodsStatus(OrderGoodsStatusEnum.Status.SUCCESS.getCode());
                            } else {
                                update.setOrderGoodsStatus(OrderGoodsStatusEnum.Status.COMPLETED.getCode());
                            }
                        } else {
                            //虽然没有余量，但是可以取消的运单都是未到达货源地的
                            update.setOrderGoodsStatus(OrderGoodsStatusEnum.Status.CANCEL.getCode());
                        }

                    }
                }
                orderGoodsDao.updateEntityByKey(update);
            }
            Result<Object> result = orderFeign.updateOrderStatusByOrderNo(orderNo, OrderEnum.Status.COMPLETED.getCode());
            if (!result.succeed()) {
                throw new RuntimeException("货主取消订单失败,原因：远程调用取消订单失败");
            }
        }
        this.ownerCancelOrder(orderNo);
 //       log.info("执行货主订单取消前置：更改相关状态完毕，开始执行吨数回填，发送MQ消息,订单No {}", orderNo);
//        OrderCancelMqParam mqParam = new OrderCancelMqParam();
//        mqParam.setType("2");
//        mqParam.setOrderNo(orderNo);
//        Message message = MessageBuilder.withBody(JSONUtil.parse(mqParam).toString().getBytes()).build();
//        rabbitTemplate.send(
//                RabbitKeyConstants.ORDER_CANCEL_EXCHANGE, RabbitKeyConstants.ORDER_CANCEL_ROUTE_KEY, message
//        );

    }

    //@Override
    //@Transactional(rollbackFor = Exception.class)
    public void ownerCancelOrder(String orderNo) {
        log.info("开始执行订单取消吨数回填");
        FeignOrderVO orderInfoFeignVO = orderFeign.getOrderInfoFeign(orderNo);

        List<OrderGoods> orderGoodsList = orderGoodsDao.getOrderGoodsListByOrderNo(orderNo);
        Map<Integer, BigDecimal> truckDemandMap = new HashMap<>();
        truckDemandMap.put(TruckDemandEnum.TruckType.PLATFORM_CAR.getCode(), BigDecimal.ZERO);
        truckDemandMap.put(TruckDemandEnum.TruckType.OWNER_CAR.getCode(), BigDecimal.ZERO);
        if (!TruckDemandEnum.TruckType.PLATFORM_ANY_CAR.getCode().equals(orderInfoFeignVO.getTruckDemand())) {
            if (OrderEnum.Status.COMPLETED.getCode().equals(orderInfoFeignVO.getOrderStatus())) {
                //已完结
                List<OrderChild> orderChildrenList = orderChildDao.selectResidueWeight(orderNo, OrderChildEnum.Status.ARRIVE_SEND.getCode());

                for (OrderChild orderChild : orderChildrenList) {
                    OrderChild update = new OrderChild();
                    update.setId(orderChild.getId());
                    update.setStatus(OrderChildEnum.Status.OWNER_CANCEL.getCode());
                    //TODO 补充批量更新接口  关闭运单状态
                    orderChildDao.updateEntityByKey(update);
                }
                Map<String, List<OrderGoods>> orderGoodsMap = orderGoodsList.stream()
                        .collect(Collectors.groupingBy(OrderGoods::getOrderGoodsNo));

                Map<String, List<OrderChild>> orderChildMap = orderChildrenList.stream()
                        .collect(Collectors.groupingBy(OrderChild::getOrderGoodsNo));

                for (Map.Entry<String, List<OrderGoods>> entry : orderGoodsMap.entrySet()) {
                    String orderGoodsNo = entry.getKey();
                    OrderGoods orderGoods = entry.getValue().get(0);
                    List<OrderChild> orderChildren = orderChildMap.get(orderGoodsNo);
                    BigDecimal sum = BigDecimal.ZERO;
                    if (CollectionUtil.isNotEmpty(orderChildren)) {
                        sum = orderChildren.stream()
                                .map(OrderChild::getWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
                    }
                    truckDemandMap.put(orderGoods.getTruckDemand(),
                            truckDemandMap.get(orderGoods.getTruckDemand())
                                    .add(orderGoods.getResidueTransportWeight().add(sum)));

                    OrderGoods update = new OrderGoods();
                    update.setId(orderGoods.getId());
                    //TODO 补充批量更新接口  关闭货单状态  注意判断货单是已完结还是已完成
                    update.setResidueTransportWeight(BigDecimal.ZERO);
                    update.setAlreadyTransportWeight(orderGoods.getAlreadyTransportWeight().subtract(sum));
//                    update.setOrderGoodsStatus(OrderGoodsStatusEnum.Status.COMPLETED.getCode());
                    orderGoodsDao.updateEntityByKey(update);
                }

            } else if (OrderEnum.Status.CANCELED.getCode().equals(orderInfoFeignVO.getOrderStatus())) {
                //已取消
                for (OrderGoods orderGoods : orderGoodsList) {
                    truckDemandMap.put(orderGoods.getTruckDemand(),
                            truckDemandMap.get(orderGoods.getTruckDemand())
                                    .add(orderGoods.getResidueTransportWeight()));
                    OrderGoods update = new OrderGoods();
                    update.setId(orderGoods.getId());
                    //TODO 补充批量更新接口  关闭货单状态
                    update.setResidueTransportWeight(BigDecimal.ZERO);

//                    update.setOrderGoodsStatus(OrderGoodsStatusEnum.Status.CANCEL.getCode());
                    orderGoodsDao.updateEntityByKey(update);
                }
            }

            Integer truckDemand = orderInfoFeignVO.getTruckDemand();
            BigDecimal residueWeight = truckDemandMap.get(truckDemand);
            if (residueWeight.compareTo(BigDecimal.ZERO) == 0) {
                log.info("当前订单对应的货单无需吨数回填,订单编号{}", orderNo);
                return;
            }

            //归还吨数
            RollbackOrderWeightParam param = new RollbackOrderWeightParam();
            param.setOrderNo(orderInfoFeignVO.getOrderNo());
            if (truckDemand.equals(TruckDemandEnum.TruckType.PLATFORM_CAR.getCode())) {
                param.setResidueWeight(residueWeight);
                param.setOwnResidueCarryWeight(BigDecimal.ZERO);
                param.setPlatformResidueCarryWeight(residueWeight);
            }
            if (truckDemand.equals(TruckDemandEnum.TruckType.OWNER_CAR.getCode())) {
                param.setResidueWeight(residueWeight);
                param.setOwnResidueCarryWeight(residueWeight);
                param.setPlatformResidueCarryWeight(BigDecimal.ZERO);
            }
            orderFeign.rollbackOrderWeight(param);

        } else {
            Map<Integer, BigDecimal> vehicleUsageMap = new HashMap<>();
            vehicleUsageMap.put(1, BigDecimal.ZERO);
            vehicleUsageMap.put(2, BigDecimal.ZERO);
            if (OrderEnum.Status.COMPLETED.getCode().equals(orderInfoFeignVO.getOrderStatus())) {
                //已完结
                List<OrderChild> orderChildrenList = orderChildDao.selectResidueWeight(orderNo, OrderChildEnum.Status.ARRIVE_SEND.getCode());

                for (OrderChild orderChild : orderChildrenList) {
                    OrderChild update = new OrderChild();
                    update.setId(orderChild.getId());
                    update.setStatus(OrderChildEnum.Status.PLATFORM_CANCEL.getCode());
                    //TODO 补充批量更新接口  关闭运单状态
                    orderChildDao.updateEntityByKey(update);
                }
                //货单
                Map<String, List<OrderGoods>> orderGoodsMap = orderGoodsList.stream()
                        .collect(Collectors.groupingBy(OrderGoods::getOrderGoodsNo));
                //运单
                Map<String, List<OrderChild>> orderChildMap = orderChildrenList.stream()
                        .collect(Collectors.groupingBy(OrderChild::getOrderGoodsNo));


                for (Map.Entry<String, List<OrderGoods>> entry : orderGoodsMap.entrySet()) {
                    String orderGoodsNo = entry.getKey();
                    OrderGoods orderGoods = entry.getValue().get(0);

                    BigDecimal sum = BigDecimal.ZERO;
                    if (CollectionUtil.isNotEmpty(orderChildMap.get(orderGoodsNo))) {
                        sum = orderChildMap.get(orderGoodsNo).stream()
                                .map(OrderChild::getWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
                    }
                    vehicleUsageMap.put(orderGoods.getVehicleUsage(),
                            vehicleUsageMap.get(orderGoods.getVehicleUsage())
                                    .add(orderGoods.getResidueTransportWeight().add(sum)));
                    OrderGoods update = new OrderGoods();
                    update.setId(orderGoods.getId());
                    //TODO 补充批量更新接口  关闭货单状态
                    update.setAlreadyTransportWeight(orderGoods.getAlreadyTransportWeight().subtract(sum));
                    update.setResidueTransportWeight(BigDecimal.ZERO);
                    //update.setOrderGoodsStatus(OrderGoodsStatusEnum.Status.COMPLETED.getCode());
                    orderGoodsDao.updateEntityByKey(update);

                }

            } else if (OrderEnum.Status.CANCELED.getCode().equals(orderInfoFeignVO.getOrderStatus())) {
                //已取消
                for (OrderGoods orderGoods : orderGoodsList) {
                    vehicleUsageMap.put(orderGoods.getVehicleUsage(),
                            vehicleUsageMap.get(orderGoods.getVehicleUsage())
                                    .add(orderGoods.getResidueTransportWeight()));
                    OrderGoods update = new OrderGoods();
                    update.setId(orderGoods.getId());
                    //TODO 补充批量更新接口  关闭货单状态
                    update.setResidueTransportWeight(BigDecimal.ZERO);
                    //update.setOrderGoodsStatus(OrderGoodsStatusEnum.Status.COMPLETED.getCode());
                    orderGoodsDao.updateEntityByKey(update);
                }
            }

            //归还吨数
            BigDecimal platformResidueSum = vehicleUsageMap.get(1);
            BigDecimal ownResidueSum = vehicleUsageMap.get(2);
            BigDecimal residueSum = platformResidueSum.add(ownResidueSum);
            RollbackOrderWeightParam param = new RollbackOrderWeightParam();
            param.setOrderNo(orderInfoFeignVO.getOrderNo());
            param.setResidueWeight(residueSum);
            param.setPlatformResidueCarryWeight(platformResidueSum);
            param.setOwnResidueCarryWeight(ownResidueSum);
            orderFeign.rollbackOrderWeight(param);
        }


    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void ownerCancelOrderPrePC(OrderCancelParam param) {
        String orderNo = param.getOrderNo();
        List<OrderGoods> orderGoodsList = null;
        Integer orderStatusCode = OrderEnum.Status.CANCELED.getCode();

        switch (param.getCancelType()) {
            case 1: //单纯取消订单
                if (CollectionUtil.isNotEmpty(orderChildDao.getOrderChildByOrderNo(orderNo))) {
                    throw new ServiceSystemException(PerformanceResultEnum.HTTP_ERROR, "当前订单已发生变化,请重新选择取消方式");
                }
                Result<Object> result = orderFeign.updateOrderStatusByOrderNo(orderNo, OrderEnum.Status.CANCELED.getCode());
                if (!result.succeed()) {
                    throw new ServiceSystemException(PerformanceResultEnum.HTTP_ERROR, "货主取消订单失败,原因：远程调用取消订单失败");
                }
                orderGoodsList = orderGoodsDao.getOrderGoodsListByOrderNo(orderNo);

                for (OrderGoods orderGoods : orderGoodsList) {
                    OrderGoods update = new OrderGoods();
                    update.setId(orderGoods.getId());
                    update.setOrderGoodsStatus(OrderGoodsStatusEnum.Status.CANCEL.getCode());
                    orderGoodsDao.updateEntityByKey(update);
                }
                break;
            case 2: //取消未拉运吨数的货单
                if (!orderFeign.updateOrderStatusByOrderNo(orderNo, OrderEnum.Status.CANCELED.getCode()).succeed()) {
                    throw new ServiceSystemException(PerformanceResultEnum.HTTP_ERROR, "货主取消订单失败,原因：远程调用取消订单失败");
                }
                orderGoodsList = orderGoodsDao.getOrderGoodsListByOrderNo(orderNo);

                for (OrderGoods orderGoods : orderGoodsList) {
                    OrderGoods update = new OrderGoods();
                    update.setId(orderGoods.getId());
                    if (orderGoods.getResidueTransportWeight().compareTo(orderGoods.getExtractWeight()) == 0) {
                        update.setOrderGoodsStatus(OrderGoodsStatusEnum.Status.CANCEL.getCode());
                    } else {
                        orderStatusCode = OrderEnum.Status.COMPLETED.getCode();
                        update.setOrderGoodsStatus(OrderGoodsStatusEnum.Status.COMPLETED.getCode());
                    }
                    orderGoodsDao.updateEntityByKey(update);
                }

                if (!orderFeign.updateOrderStatusByOrderNo(orderNo, orderStatusCode).succeed()) {
                    throw new ServiceSystemException(PerformanceResultEnum.HTTP_ERROR, "货主取消订单失败,原因：远程调用取消订单失败");

                }
                break;

            case 3: //取消未拉运+未到达货源地吨数
                List<OrderChild> orderChildren = orderChildDao.selectResidueWeight(orderNo, OrderChildEnum.Status.ARRIVE_SEND.getCode());
                if (CollectionUtil.isEmpty(orderChildren)) {
                    throw new ServiceSystemException(PerformanceResultEnum.HTTP_ERROR, "当前订单已发生变化,请重新选择取消方式");
                }
                if (!orderFeign.updateOrderStatusByOrderNo(orderNo, OrderEnum.Status.CANCELED.getCode()).succeed()) {
                    throw new ServiceSystemException(PerformanceResultEnum.HTTP_ERROR, "货主取消订单失败,原因：远程调用取消订单失败");
                }
                List<Integer> ids = orderChildren.stream().map(OrderChild::getId).collect(Collectors.toList());
                orderChildDao.batchUpdateOrderChildStatus(OrderChildEnum.Status.OWNER_CANCEL.getCode(), ids);
                orderGoodsList = orderGoodsDao.getOrderGoodsListByOrderNo(orderNo);
                Map<String, List<OrderChild>> orderChildMap = orderChildren.stream()
                        .collect(Collectors.groupingBy(OrderChild::getOrderGoodsNo));

                for (OrderGoods orderGoods : orderGoodsList) {
                    OrderGoods update = new OrderGoods();
                    update.setId(orderGoods.getId());
                    if (CollectionUtil.isEmpty(orderChildMap.get(orderGoods.getOrderGoodsNo()))) {
                        update.setOrderGoodsStatus(OrderGoodsStatusEnum.Status.CANCEL.getCode());
                    } else {
                        BigDecimal reduce = orderChildMap.get(orderGoods.getOrderGoodsNo())
                                .stream().map(OrderChild::getWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
                        if (orderGoods.getExtractWeight().compareTo(orderGoods.getResidueTransportWeight().add(reduce)) == 0) {
                            update.setOrderGoodsStatus(OrderGoodsStatusEnum.Status.CANCEL.getCode());
                        } else {
                            orderStatusCode = OrderEnum.Status.COMPLETED.getCode();
                            update.setOrderGoodsStatus(OrderGoodsStatusEnum.Status.COMPLETED.getCode());
                        }
                    }
                    orderGoodsDao.updateEntityByKey(update);
                }
                if (!orderFeign.updateOrderStatusByOrderNo(orderNo, orderStatusCode).succeed()) {
                    throw new ServiceSystemException(PerformanceResultEnum.HTTP_ERROR, "货主取消订单失败,原因：远程调用取消订单失败");

                }
                break;


            default:
                throw new ServiceSystemException(PerformanceResultEnum.HTTP_ERROR, "参数有误");

        }

        log.info("执行货主订单取消前置：更改相关状态完毕，开始执行吨数回填，发送MQ消息,订单No {}", orderNo);

        Message message = MessageBuilder.withBody(JSONUtil.parse(param).toString().getBytes()).build();
        rabbitTemplate.send(
                RabbitKeyConstants.ORDER_CANCEL_EXCHANGE, RabbitKeyConstants.ORDER_CANCEL_ROUTE_KEY, message
        );
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void platformCancelOrderPrePC(OrderCancelParam param) {
        String orderNo = param.getOrderNo();
        List<OrderGoods> orderGoodsList = null;
        Integer orderStatusCode = OrderEnum.Status.CANCELED.getCode();

        switch (param.getCancelType()) {
            case 1: //单纯取消订单
                if (CollectionUtil.isNotEmpty(orderChildDao.getOrderChildByOrderNo(orderNo))) {
                    throw new ServiceSystemException(PerformanceResultEnum.HTTP_ERROR, "当前订单已发生变化,请重新选择取消方式");
                }
                Result<Object> result = orderFeign.updateOrderStatusByOrderNo(orderNo, OrderEnum.Status.CANCELED.getCode());
                if (!result.succeed()) {
                    throw new ServiceSystemException(PerformanceResultEnum.HTTP_ERROR, "货主取消订单失败,原因：远程调用取消订单失败");
                }
                orderGoodsList = orderGoodsDao.getOrderGoodsListByOrderNo(orderNo);

                for (OrderGoods orderGoods : orderGoodsList) {
                    OrderGoods update = new OrderGoods();
                    update.setId(orderGoods.getId());
                    update.setOrderGoodsStatus(OrderGoodsStatusEnum.Status.CANCEL.getCode());
                    orderGoodsDao.updateEntityByKey(update);
                }
                break;
            case 2: //取消未拉运吨数的货单
                if (!orderFeign.updateOrderStatusByOrderNo(orderNo, OrderEnum.Status.CANCELED.getCode()).succeed()) {
                    throw new ServiceSystemException(PerformanceResultEnum.HTTP_ERROR, "货主取消订单失败,原因：远程调用取消订单失败");
                }
                orderGoodsList = orderGoodsDao.getOrderGoodsListByOrderNo(orderNo);

                for (OrderGoods orderGoods : orderGoodsList) {
                    OrderGoods update = new OrderGoods();
                    update.setId(orderGoods.getId());
                    if (orderGoods.getResidueTransportWeight().compareTo(orderGoods.getExtractWeight()) == 0) {
                        update.setOrderGoodsStatus(OrderGoodsStatusEnum.Status.CANCEL.getCode());
                    } else {
                        orderStatusCode = OrderEnum.Status.COMPLETED.getCode();
                        update.setOrderGoodsStatus(OrderGoodsStatusEnum.Status.COMPLETED.getCode());
                    }
                    orderGoodsDao.updateEntityByKey(update);
                }

                if (!orderFeign.updateOrderStatusByOrderNo(orderNo, orderStatusCode).succeed()) {
                    throw new ServiceSystemException(PerformanceResultEnum.HTTP_ERROR, "货主取消订单失败,原因：远程调用取消订单失败");

                }
                break;

            case 3: //取消未拉运+未到达货源地吨数
                List<OrderChild> orderChildren = orderChildDao.selectResidueWeight(orderNo, OrderChildEnum.Status.ARRIVE_SEND.getCode());
                if (CollectionUtil.isEmpty(orderChildren)) {
                    throw new ServiceSystemException(PerformanceResultEnum.HTTP_ERROR, "当前订单已发生变化,请重新选择取消方式");
                }
                if (!orderFeign.updateOrderStatusByOrderNo(orderNo, OrderEnum.Status.CANCELED.getCode()).succeed()) {
                    throw new ServiceSystemException(PerformanceResultEnum.HTTP_ERROR, "货主取消订单失败,原因：远程调用取消订单失败");
                }
                List<Integer> ids = orderChildren.stream().map(OrderChild::getId).collect(Collectors.toList());
                orderChildDao.batchUpdateOrderChildStatus(OrderChildEnum.Status.PLATFORM_CANCEL.getCode(), ids);
                orderGoodsList = orderGoodsDao.getOrderGoodsListByOrderNo(orderNo);
                Map<String, List<OrderChild>> orderChildMap = orderChildren.stream()
                        .collect(Collectors.groupingBy(OrderChild::getOrderGoodsNo));

                for (OrderGoods orderGoods : orderGoodsList) {
                    OrderGoods update = new OrderGoods();
                    update.setId(orderGoods.getId());
                    if (CollectionUtil.isEmpty(orderChildMap.get(orderGoods.getOrderGoodsNo()))) {
                        update.setOrderGoodsStatus(OrderGoodsStatusEnum.Status.CANCEL.getCode());
                    } else {
                        BigDecimal reduce = orderChildMap.get(orderGoods.getOrderGoodsNo())
                                .stream().map(OrderChild::getWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
                        if (orderGoods.getExtractWeight().compareTo(orderGoods.getResidueTransportWeight().add(reduce)) == 0) {
                            update.setOrderGoodsStatus(OrderGoodsStatusEnum.Status.CANCEL.getCode());
                        } else {
                            orderStatusCode = OrderEnum.Status.COMPLETED.getCode();
                            update.setOrderGoodsStatus(OrderGoodsStatusEnum.Status.COMPLETED.getCode());
                        }
                    }
                    orderGoodsDao.updateEntityByKey(update);
                }
                if (!orderFeign.updateOrderStatusByOrderNo(orderNo, orderStatusCode).succeed()) {
                    throw new ServiceSystemException(PerformanceResultEnum.HTTP_ERROR, "货主取消订单失败,原因：远程调用取消订单失败");

                }
                break;

            default:
                throw new ServiceSystemException(PerformanceResultEnum.HTTP_ERROR, "参数有误");

        }

        log.info("执行承运端订单取消前置：更改相关状态完毕，开始执行吨数回填，发送MQ消息,订单No {}", orderNo);

        Message message = MessageBuilder.withBody(JSONUtil.parse(param).toString().getBytes()).build();
        rabbitTemplate.send(
                RabbitKeyConstants.ORDER_CANCEL_EXCHANGE, RabbitKeyConstants.ORDER_CANCEL_ROUTE_KEY, message
        );
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void ownerCancelOrderPrePCMQ(OrderCancelParam param) {
        Map<Integer, BigDecimal> truckDemandMap = new HashMap<>();
        truckDemandMap.put(TruckDemandEnum.TruckType.PLATFORM_CAR.getCode(), BigDecimal.ZERO);
        truckDemandMap.put(TruckDemandEnum.TruckType.OWNER_CAR.getCode(), BigDecimal.ZERO);
        Map<Integer, BigDecimal> vehicleUsageMap = new HashMap<>();
        vehicleUsageMap.put(1, BigDecimal.ZERO);
        vehicleUsageMap.put(2, BigDecimal.ZERO);
        RollbackOrderWeightParam rollbackOrderWeightParam = new RollbackOrderWeightParam();

        String orderNo = param.getOrderNo();
        FeignOrderVO orderInfoFeign = orderFeign.getOrderInfoFeign(orderNo);
        Integer truckDemand = orderInfoFeign.getTruckDemand();
        List<OrderGoods> orderGoodsList = null;
        switch (param.getCancelType()) {
            case 1: //单纯取消订单
                orderGoodsList = orderGoodsDao.getOrderGoodsListByOrderNo(orderNo);
                if (!orderInfoFeign.getTruckDemand().equals(TruckDemandEnum.TruckType.PLATFORM_ANY_CAR.getCode())) {
                    for (OrderGoods orderGoods : orderGoodsList) {
                        OrderGoods update = new OrderGoods();
                        update.setId(orderGoods.getId());
                        truckDemandMap.put(orderGoods.getTruckDemand(),
                                truckDemandMap.get(orderGoods.getTruckDemand())
                                        .add(orderGoods.getResidueTransportWeight()));
                        update.setResidueTransportWeight(BigDecimal.ZERO);
                        orderGoodsDao.updateEntityByKey(update);
                    }
                } else {
                    for (OrderGoods orderGoods : orderGoodsList) {
                        OrderGoods update = new OrderGoods();
                        update.setId(orderGoods.getId());
                        vehicleUsageMap.put(orderGoods.getVehicleUsage(),
                                vehicleUsageMap.get(orderGoods.getVehicleUsage())
                                        .add(orderGoods.getResidueTransportWeight()));
                        update.setResidueTransportWeight(BigDecimal.ZERO);
                        orderGoodsDao.updateEntityByKey(update);
                    }
                }
                //归还吨数
                if (!orderInfoFeign.getTruckDemand().equals(TruckDemandEnum.TruckType.PLATFORM_ANY_CAR.getCode())) {
                    rollbackOrderWeightParam.setOrderNo(orderNo);
                    if (truckDemand.equals(TruckDemandEnum.TruckType.PLATFORM_CAR.getCode())) {
                        rollbackOrderWeightParam.setResidueWeight(truckDemandMap.get(truckDemand));
                        rollbackOrderWeightParam.setOwnResidueCarryWeight(BigDecimal.ZERO);
                        rollbackOrderWeightParam.setPlatformResidueCarryWeight(truckDemandMap.get(truckDemand));
                    }
                    if (truckDemand.equals(TruckDemandEnum.TruckType.OWNER_CAR.getCode())) {
                        rollbackOrderWeightParam.setResidueWeight(truckDemandMap.get(truckDemand));
                        rollbackOrderWeightParam.setOwnResidueCarryWeight(truckDemandMap.get(truckDemand));
                        rollbackOrderWeightParam.setPlatformResidueCarryWeight(BigDecimal.ZERO);
                    }
                } else {
                    BigDecimal platformResidueSum = vehicleUsageMap.get(1);
                    BigDecimal ownResidueSum = vehicleUsageMap.get(2);
                    BigDecimal residueSum = platformResidueSum.add(ownResidueSum);
                    rollbackOrderWeightParam.setOrderNo(orderNo);
                    rollbackOrderWeightParam.setResidueWeight(residueSum);
                    rollbackOrderWeightParam.setPlatformResidueCarryWeight(platformResidueSum);
                    rollbackOrderWeightParam.setOwnResidueCarryWeight(ownResidueSum);
                }
                orderFeign.rollbackOrderWeight(rollbackOrderWeightParam);
                return;
            case 2: //取消未拉运吨数的货单
                orderGoodsList = orderGoodsDao.getOrderGoodsListByOrderNo(orderNo);

                if (!orderInfoFeign.getTruckDemand().equals(TruckDemandEnum.TruckType.PLATFORM_ANY_CAR.getCode())) {
                    for (OrderGoods orderGoods : orderGoodsList) {
                        OrderGoods update = new OrderGoods();
                        update.setId(orderGoods.getId());
                        truckDemandMap.put(orderGoods.getTruckDemand(),
                                truckDemandMap.get(orderGoods.getTruckDemand())
                                        .add(orderGoods.getResidueTransportWeight()));
                        update.setResidueTransportWeight(BigDecimal.ZERO);
                        orderGoodsDao.updateEntityByKey(update);
                    }
                } else {
                    for (OrderGoods orderGoods : orderGoodsList) {
                        OrderGoods update = new OrderGoods();
                        update.setId(orderGoods.getId());
                        vehicleUsageMap.put(orderGoods.getVehicleUsage(),
                                vehicleUsageMap.get(orderGoods.getVehicleUsage())
                                        .add(orderGoods.getResidueTransportWeight()));
                        update.setResidueTransportWeight(BigDecimal.ZERO);
                        orderGoodsDao.updateEntityByKey(update);
                    }
                }
                //归还吨数
                if (!orderInfoFeign.getTruckDemand().equals(TruckDemandEnum.TruckType.PLATFORM_ANY_CAR.getCode())) {
                    rollbackOrderWeightParam.setOrderNo(orderNo);
                    if (truckDemand.equals(TruckDemandEnum.TruckType.PLATFORM_CAR.getCode())) {
                        rollbackOrderWeightParam.setResidueWeight(truckDemandMap.get(truckDemand));
                        rollbackOrderWeightParam.setOwnResidueCarryWeight(BigDecimal.ZERO);
                        rollbackOrderWeightParam.setPlatformResidueCarryWeight(truckDemandMap.get(truckDemand));
                    }
                    if (truckDemand.equals(TruckDemandEnum.TruckType.OWNER_CAR.getCode())) {
                        rollbackOrderWeightParam.setResidueWeight(truckDemandMap.get(truckDemand));
                        rollbackOrderWeightParam.setOwnResidueCarryWeight(truckDemandMap.get(truckDemand));
                        rollbackOrderWeightParam.setPlatformResidueCarryWeight(BigDecimal.ZERO);
                    }
                } else {
                    BigDecimal platformResidueSum = vehicleUsageMap.get(1);
                    BigDecimal ownResidueSum = vehicleUsageMap.get(2);
                    BigDecimal residueSum = platformResidueSum.add(ownResidueSum);
                    rollbackOrderWeightParam.setOrderNo(orderNo);
                    rollbackOrderWeightParam.setResidueWeight(residueSum);
                    rollbackOrderWeightParam.setPlatformResidueCarryWeight(platformResidueSum);
                    rollbackOrderWeightParam.setOwnResidueCarryWeight(ownResidueSum);
                }
                orderFeign.rollbackOrderWeight(rollbackOrderWeightParam);
                return;

            case 3: //取消未拉运+未到达货源地吨数
                List<OrderChild> orderChildren = orderChildDao.selectResidueWeight(orderNo, OrderChildEnum.Status.ARRIVE_SEND.getCode());
                orderGoodsList = orderGoodsDao.getOrderGoodsListByOrderNo(orderNo);
                Map<String, List<OrderChild>> orderChildMap = orderChildren.stream()
                        .collect(Collectors.groupingBy(OrderChild::getOrderGoodsNo));
                if (!orderInfoFeign.getTruckDemand().equals(TruckDemandEnum.TruckType.PLATFORM_ANY_CAR.getCode())) {
                    for (OrderGoods orderGoods : orderGoodsList) {
                        OrderGoods update = new OrderGoods();
                        update.setId(orderGoods.getId());
                        truckDemandMap.put(orderGoods.getTruckDemand(),
                                truckDemandMap.get(orderGoods.getTruckDemand())
                                        .add(orderGoods.getResidueTransportWeight()));
                        update.setResidueTransportWeight(BigDecimal.ZERO);
                        if (CollectionUtil.isNotEmpty(orderChildMap.get(orderGoods.getOrderGoodsNo()))) {
                            BigDecimal childSum = orderChildMap.get(orderGoods.getOrderGoodsNo()).stream()
                                    .map(OrderChild::getWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
                            update.setAlreadyTransportWeight(
                                    orderGoods.getAlreadyTransportWeight()
                                            .subtract(
                                                    childSum
                                            )
                            );
                            truckDemandMap.put(orderGoods.getTruckDemand(),
                                    truckDemandMap.get(orderGoods.getTruckDemand())
                                            .add(childSum));
                        }

                        orderGoodsDao.updateEntityByKey(update);
                    }
                } else {
                    for (OrderGoods orderGoods : orderGoodsList) {
                        OrderGoods update = new OrderGoods();
                        update.setId(orderGoods.getId());
                        vehicleUsageMap.put(orderGoods.getVehicleUsage(),
                                vehicleUsageMap.get(orderGoods.getVehicleUsage())
                                        .add(orderGoods.getResidueTransportWeight()));
                        update.setResidueTransportWeight(BigDecimal.ZERO);
                        if (CollectionUtil.isNotEmpty(orderChildMap.get(orderGoods.getOrderGoodsNo()))) {
                            BigDecimal childSum = orderChildMap.get(orderGoods.getOrderGoodsNo()).stream()
                                    .map(OrderChild::getWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
                            update.setAlreadyTransportWeight(
                                    orderGoods.getAlreadyTransportWeight()
                                            .subtract(
                                                    childSum
                                            )
                            );
                            vehicleUsageMap.put(orderGoods.getTruckDemand(),
                                    vehicleUsageMap.get(orderGoods.getTruckDemand())
                                            .add(childSum));
                        }
                        orderGoodsDao.updateEntityByKey(update);
                    }
                }
                //归还吨数
                if (!orderInfoFeign.getTruckDemand().equals(TruckDemandEnum.TruckType.PLATFORM_ANY_CAR.getCode())) {
                    rollbackOrderWeightParam.setOrderNo(orderNo);
                    if (truckDemand.equals(TruckDemandEnum.TruckType.PLATFORM_CAR.getCode())) {
                        rollbackOrderWeightParam.setResidueWeight(truckDemandMap.get(truckDemand));
                        rollbackOrderWeightParam.setOwnResidueCarryWeight(BigDecimal.ZERO);
                        rollbackOrderWeightParam.setPlatformResidueCarryWeight(truckDemandMap.get(truckDemand));
                    }
                    if (truckDemand.equals(TruckDemandEnum.TruckType.OWNER_CAR.getCode())) {
                        rollbackOrderWeightParam.setResidueWeight(truckDemandMap.get(truckDemand));
                        rollbackOrderWeightParam.setOwnResidueCarryWeight(truckDemandMap.get(truckDemand));
                        rollbackOrderWeightParam.setPlatformResidueCarryWeight(BigDecimal.ZERO);
                    }
                } else {
                    BigDecimal platformResidueSum = vehicleUsageMap.get(1);
                    BigDecimal ownResidueSum = vehicleUsageMap.get(2);
                    BigDecimal residueSum = platformResidueSum.add(ownResidueSum);
                    rollbackOrderWeightParam.setOrderNo(orderNo);
                    rollbackOrderWeightParam.setResidueWeight(residueSum);
                    rollbackOrderWeightParam.setPlatformResidueCarryWeight(platformResidueSum);
                    rollbackOrderWeightParam.setOwnResidueCarryWeight(ownResidueSum);
                }
                orderFeign.rollbackOrderWeight(rollbackOrderWeightParam);
                return;

        }
    }
}