package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum BreakContractSettlementDriverEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum BreakContractPartyType {
        PLATFORM(1, "平台"),
        OWNER(2, "货主"),
        DRIVER(3, "司机"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<BreakContractPartyType> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(BreakContractPartyType::getMsg).orElse(null);
        }
    }

    @Getter
    @AllArgsConstructor
    public enum SettleStatus {
        NO(1, "待结算"),
        YES(2, "已结算"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<SettleStatus> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(SettleStatus::getMsg).orElse(null);
        }
    }

    @Getter
    @AllArgsConstructor
    public enum SettlePlatform {
        MSL(0, "马上来"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<SettlePlatform> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(SettlePlatform::getMsg).orElse(null);
        }
    }

}
