package com.clx.order.params;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
public class OrderGoodsEditParams {

    private Integer id;

    @ApiModelProperty("货单编号")
    private String orderGoodsNo;

    @ApiModelProperty("用车方式 1：平台车辆配货 2：自有车辆配货")
    private Integer vehicleUsage;

    @ApiModelProperty("提取吨数")
    private BigDecimal extractWeight;

    @ApiModelProperty("剩余拉运吨数")
    private BigDecimal residueTransportWeight;

    @ApiModelProperty("挂单方式  1公开派单  2定向派单")
    private Integer pendingOrderWay;

    @ApiModelProperty("'最晚接单时间'")
    private String lastOrderTime;
    
    @ApiModelProperty("最晚到达货源地时间")
    private String lastArriveSendTime;

    @ApiModelProperty("最晚装货时间")
    private String lastLoadTime;

    @ApiModelProperty("最晚到达目的地时间")
    private String lastArriveReceiveTime;

    @ApiModelProperty("挂单时间")
    private String pendingOrderTime;
    
    @ApiModelProperty("提取方式 1提取全部 2提取部分")
    private Integer extractWay;

    @ApiModelProperty("需要车辆/辆")
    private Integer needTruckNum;

    @ApiModelProperty("挂单运费")
    private BigDecimal pendingOrderFreight;

    @ApiModelProperty("创建人用户编号")
    private Long userNo;

    @ApiModelProperty("创建人姓名")
    private String userName;

    @ApiModelProperty("批次号")
    private Long batchNumber;

    @ApiModelProperty("修改时间")
    private String modifiedTime;

    @ApiModelProperty("车辆列表")
    private List<String> truckList;
}
