package com.clx.performance.service;

import com.clx.performance.param.pc.OrderCancelParam;

public interface OrderCancelService {

    /**
     * 承运端取消订单，货主同意调用此接口
     * @param orderNo
     */
    void ownerConfirmCancelOrderPre(String orderNo);

    void ownerConfirmCancelProcess(String orderNo);

    /**
     * 货主取消订单前置（只修改订单状态）
     * @param param
     */
    void ownerCancelOrderPre(OrderCancelParam param);

    /**
     * 平台取消订单前置(只修改订单状态)
     * @param param
     */
    void platformCancelOrderPre(OrderCancelParam param);

    /**
     * 修改订单状态后执行规划吨数
     * @param param
     */
    void orderCancelProcess(OrderCancelParam param);

}
