package com.clx.performance.listener;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.clx.performance.constant.RabbitKeyConstants;
import com.clx.performance.enums.RoleEnum;
import com.clx.performance.param.pc.OrderCancelParam;
import com.clx.performance.service.OrderCancelService;
import com.clx.performance.service.breakcontract.BreakContractSettlementOwnerService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * 处理货单取消吨数回填
 */
@Slf4j
@Component
public class OrderCancelHandler {

    @Autowired
    private OrderCancelService orderCancelService;

    @Autowired
    private BreakContractSettlementOwnerService breakContractSettlementOwnerService;



    @RabbitListener(queues = RabbitKeyConstants.ORDER_CANCEL_QUEUE)
    public void onMessage(String message) {
        log.info("处理订单取消监听器执行,订单No为{}", message);
        OrderCancelParam param = JSONUtil.toBean(message, OrderCancelParam.class);
        orderCancelService.orderCancelProcess(param);

//        //货主端取消订单进行违约计费
//        if(Objects.equals(param.getCreateByType(), RoleEnum.Type.OWNER)){
//            breakContractSettlementOwnerService.saveSettlementOwnerForCancelOrder(param.getOrderNo());
//        }

    }
}
