package com.clx.performance.controller.feign;


import com.clx.performance.param.pc.OrderCancelFeignParam;
import com.clx.performance.param.pc.OrderCancelParam;
import com.clx.performance.service.OrderCancelService;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
@RequestMapping("/feign/order")
@Validated
@AllArgsConstructor
@Api(tags = "Feign-订单取消")
public class OrderCancelFeignController {


    private final OrderCancelService orderCancelService;

    @ApiOperation(value = "货主端订单取消", notes = "<br>By:胡宇帆")
    @PostMapping("/orderCancel")
    public Result<Object> orderCancel(@RequestBody OrderCancelFeignParam param) {
//        OrderCancelParam cancelParam = new OrderCancelParam();
//        cancelParam.setOrderNo(param.getOrderNo());
//        cancelParam.setCancelType(3);
//        cancelParam.setCreateByType(1);
//        orderCancelService.platformCancelOrderPrePC(cancelParam);
        orderCancelService.ownerConfirmCancelOrderPre(param.getOrderNo());
        return Result.ok();
    }
}
