
package com.clx.performance.service.impl;

import com.clx.performance.service.DriverNoticeConfigService;
import com.clx.performance.vo.pc.DriverNoticeConfigVO;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.data.redis.core.RedisTemplate;

import java.math.BigDecimal;

import static org.mockito.Mockito.when;

@ExtendWith(MockitoExtension.class)
public class OrderChildServiceImpl2Test {

    @Mock
    private RedisTemplate redisTemplate;

    @Mock
    private DriverNoticeConfigService driverNoticeConfigService;

    @InjectMocks
    private OrderChildServiceImpl orderChildService;

    @BeforeEach
    void setUp() {
        // Setup common mock interactions here if any
    }

    @Test
    void testOrderChildMessageNotice() {
        orderChildService.orderChildMessageNotice();
    }


    @Test
    void testOrderChildMessageNoticeListConfigDisabled() {
        // Arrange
        DriverNoticeConfigVO configVO = new DriverNoticeConfigVO();
        configVO.setStatus(0);
        configVO.setNoticeTriggerDistance(BigDecimal.valueOf(5000));
        when(driverNoticeConfigService.listConfig()).thenReturn(configVO);

        orderChildService.orderChildMessageNotice();
    }

}