package com.clx.performance.service.settle;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.model.OrderChild;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.model.settle.SettlementDriverDetail;
import com.clx.performance.param.pc.carrier.CarrierSettlementOwnerDetailCompanyUpdateParam;
import com.clx.performance.param.pc.carrier.ExportBatchOwnerSettlementDetailParam;
import com.clx.performance.param.pc.owner.PageCarrierSettlementOwnerDetailParam;
import com.clx.performance.param.pc.owner.PageInvoiceOwnerSettlementOwnerDetailParam;
import com.clx.performance.param.pc.owner.PageOwnerSettlementOwnerDetailParam;
import com.clx.performance.param.pc.owner.PagePendingCarrierSettlementOwnerDetailParam;
import com.clx.performance.vo.pc.carrier.settle.CarrierPagePendingSettlementOwnerDetailVO;
import com.clx.performance.vo.pc.carrier.settle.CarrierPageSettlementOwnerDetailVO;
import com.clx.performance.vo.pc.owner.settle.CountOwnerSettlementOwnerDetailVO;
import com.clx.performance.vo.pc.owner.settle.PageOwnerSettlementOwnerDetailVO;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

/**
 * @author liruixin
 * Date 2023-10-12
 * Time 09:43
 */
public interface SettlementOwnerDetailService  {

    Integer saveSettlementDetail(OrderChild orderChild, OrderGoods orderGoods, SettlementDriverDetail settlementDriverDetail);

    void updateInvoiceCompany(CarrierSettlementOwnerDetailCompanyUpdateParam param);

    IPage<PageOwnerSettlementOwnerDetailVO> pageOwnerSettlementOrderDetailList(PageOwnerSettlementOwnerDetailParam param);

    IPage<PageOwnerSettlementOwnerDetailVO> pageInvoiceOwnerSettlementOrderDetailList(PageInvoiceOwnerSettlementOwnerDetailParam param);

    CountOwnerSettlementOwnerDetailVO countInvoiceOwnerSettlementOrderDetailList(PageInvoiceOwnerSettlementOwnerDetailParam param);

    IPage<CarrierPageSettlementOwnerDetailVO> pageSettlementOwnerDetail(PageCarrierSettlementOwnerDetailParam param);

    SXSSFWorkbook exportOwnerSettlementOrderDetail(PageOwnerSettlementOwnerDetailParam param);

    Integer getInvoiceType(String orderNo);

    Boolean thawAndLockSettlement(String orderNo);

    IPage<CarrierPagePendingSettlementOwnerDetailVO> pagePendingSettlementOwnerDetail(PagePendingCarrierSettlementOwnerDetailParam param);

    SXSSFWorkbook exportPendingSettlementOwnerDetail(PagePendingCarrierSettlementOwnerDetailParam param);

    SXSSFWorkbook exportBatchSettlementOwnerDetail(ExportBatchOwnerSettlementDetailParam param);

    SXSSFWorkbook exportInvoiceOwnerSettlementOrderDetail(PageInvoiceOwnerSettlementOwnerDetailParam param);
}
