package com.clx.performance.dao.impl;

import com.clx.performance.dao.OrderChildOperateLimitConfigDao;
import com.clx.performance.mapper.OrderChildOperateLimitConfigMapper;
import com.clx.performance.model.OrderChildOperateLimitConfig;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

/**
 * @author jiangwj
 * Date 2024-08-07
 * Time 16:29
 */
@Repository
public class OrderChildOperateLimitConfigDaoImpl extends BaseDaoImpl<OrderChildOperateLimitConfigMapper, OrderChildOperateLimitConfig, Integer> implements OrderChildOperateLimitConfigDao {

    @Override
    public OrderChildOperateLimitConfig listConfig() {
        return list().get(0);
    }

    @Override
    public boolean updateConfig(OrderChildOperateLimitConfig config) {
        return update(lUdWrapper()
                .eq(OrderChildOperateLimitConfig::getId, config.getId())
                .set(StringUtils.isNotBlank(config.getName()), OrderChildOperateLimitConfig::getName, config.getName())
                .set(config.getAllowUploadDistance() != null, OrderChildOperateLimitConfig::getAllowUploadDistance, config.getAllowUploadDistance())
                .set(config.getStatus() != null, OrderChildOperateLimitConfig::getStatus, config.getStatus())
        );
    }

    @Override
    public boolean updateStatus(Integer id, Integer status) {
        return update(lUdWrapper()
                .eq(OrderChildOperateLimitConfig::getId, id)
                .set(OrderChildOperateLimitConfig::getStatus, status)
        );
    }
}
