package com.clx.performance.config;

import com.clx.performance.dao.AppDao;
import com.clx.performance.enums.AppEnum;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.model.App;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @Author liruixin
 * @create 2024-01-10 13:19
 */
@Component
public class LoadAppConfig {


    private App purchaseManageApp;

    @Autowired
    private AppDao appDao;


    public App getPurchaseManageApp() {
        if (purchaseManageApp == null) {
            purchaseManageApp = appDao.getOneByField(App::getUniqueIdentifier, AppEnum.UniqueIdentifier.PURCHASE_MANAGE.getCode()).orElseThrow(
                    PerformanceResultEnum.DATA_NOT_FIND);;
        }
        return purchaseManageApp;
    }

}
