package com.clx.performance.sqlProvider.settle;

import com.clx.performance.param.pc.PageNetworkCaseOutRecordListParam;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

public class NetworkCaseOutRecordProvider {

    public String networkCaseOutRecord(@Param("param") PageNetworkCaseOutRecordListParam param) {
        String sql = new SQL() {{
            SELECT("a.id,a.case_out_no,a.driver_user_no," +
                    " a.driver_user_name,a.payee,a.bank,a.collection_bank_code,a.status,a.status_msg,a.platform,a.order_no,a.order_goods_no," +
                    "a.child_no,a.mobile,a.alteration_balance, " +
                    "a.create_by," +
                    "date_format(a.finish_time, '%Y-%m-%d %H:%i:%s') as finish_time,date_format(a.create_time, '%Y-%m-%d %H:%i:%s') as create_time");
            FROM("network_case_out_record a");

            if (StringUtils.isNotBlank(param.getDriverUserNo())) {
                WHERE("a.driver_user_no = #{param.driverUserNo}");
            }
            if (StringUtils.isNotBlank(param.getMobile())) {
                WHERE("a.mobile = #{param.mobile}");
            }

            if (StringUtils.isNotBlank(param.getChildNo())) {
                WHERE("a.child_no = #{param.childNo}");
            }
            ORDER_BY("a.create_time desc");
        }}.toString();
        return sql;
    }

}
