package com.clx.performance.service.impl;

import com.clx.performance.param.app.OrderChildWeighPictureParam;
import com.clx.performance.service.OrderChildService;
import com.clx.performance.service.OrderChildWeighPictureService;
import com.clx.performance.vo.app.PictureVo;
import com.smart.weight.dto.WeighingSignatureDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author liruixin
 * Date 2024-08-02
 * Time 15:38
 */
@Service
public class OrderChildWeighPictureServiceImpl  implements OrderChildWeighPictureService {

    @Autowired
    private OrderChildService orderChildService;

    @Override
    public PictureVo getWeighPictures(OrderChildWeighPictureParam param) {
        //电子磅单图片
        List<WeighingSignatureDto> images = orderChildService.getWeighingSignature(param.getChildNo());
        PictureVo vo = new PictureVo();
        vo.setLoadImages(images.stream().filter(
                item -> Objects.equals(item.getType(), 1)).map(
                item -> item.getOriginalImg()).collect(Collectors.toList()));
        vo.setUnloadImages(images.stream().filter(
                item -> Objects.equals(item.getType(), 2)).map(
                item -> item.getOriginalImg()).collect(Collectors.toList()));
        return vo;
    }
}
