package com.clx.performance.service.impl;

import com.clx.performance.dao.DriverNoticeConfigDao;
import com.clx.performance.enums.EnabledStatusEnum;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.model.DriverNoticeConfig;
import com.clx.performance.param.pc.SaveDriverNoticeConfigParam;
import com.clx.performance.service.DriverNoticeConfigService;
import com.clx.performance.struct.DriverNoticeConfigStruct;
import com.clx.performance.vo.pc.DriverNoticeConfigVO;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

/**
 * @author jiangwj
 * Date 2024-08-07
 * Time 16:29
 */
@Service
@AllArgsConstructor
public class DriverNoticeConfigServiceImpl implements DriverNoticeConfigService {

    private final DriverNoticeConfigDao dao;

    private final DriverNoticeConfigStruct struct;

    @Override
    public DriverNoticeConfigVO listConfig() {
        return struct.convertVO(dao.listConfig());
    }

    @Override
    public DriverNoticeConfigVO getDetail(Integer id) {
        DriverNoticeConfig config = dao.getEntityByKey(id).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        return struct.convertVO(config);
    }

    @Override
    public void updateConfig(SaveDriverNoticeConfigParam param) {
        DriverNoticeConfig config = new DriverNoticeConfig();
        config.setId(param.getId());
        config.setNoticeTriggerDistance(param.getNoticeTriggerDistance());
        dao.updateConfig(config);
    }

    @Override
    public void enableConfig(Integer id) {
        dao.updateStatus(id, EnabledStatusEnum.ENABLE.getCode());
    }

    @Override
    public void disableConfig(Integer id) {
        dao.updateStatus(id, EnabledStatusEnum.DISABLE.getCode());
    }
}
