package com.clx.performance.param.feign.transport;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;

@Getter
@Setter
@ToString
@NoArgsConstructor
public class OrderChildTruckInfoDTO {

//    @ApiModelProperty(value = "运单号", dataType="String", required = true)
//    private String childNo;
//    @ApiModelProperty(value = "车辆ID", dataType="Integer", required = true)
//    private Integer truckId;
//    @ApiModelProperty(value = "车主id", dataType="Integer", required = true)
//    private Integer userId;

    @ApiModelProperty(value = "车主手机号", dataType="String", required = true)
    @NotBlank(message = "车主手机号不能为空")
    private String mobile;
    @ApiModelProperty(value = "车牌号", dataType="String", required = true)
    @NotBlank(message = "车牌号不能为空")
    private String truckNo;

//    @ApiModelProperty(value = "车头车牌颜色代码", dataType="Integer", required = true)
//    private Integer truckNoColorCode;

    @ApiModelProperty(value = "车头车牌颜色", dataType="String", required = true)
    @NotBlank(message = "车头车牌颜色不能为空")
    private String truckNoColor;
    @ApiModelProperty(value = "型号", dataType="String", required = true)
    @NotBlank(message = "型号不能为空")
    private String model;
    @ApiModelProperty(value = "载重单位吨", dataType="Integer", required = true)
    @NotNull(message = "载重单位吨不能为空")
    private Integer load;
    @ApiModelProperty(value = "吨位 单位吨", dataType="Integer", required = true)
    @NotNull(message = "吨位不能为空")
    private Integer grossMass;

    @ApiModelProperty(value = "车头道路运输许可证编号", dataType="String", required = true)
    @NotBlank(message = "车头道路运输许可证编号不能为空")
    private String roadTransportCertificateNo;
    @ApiModelProperty(value = "行驶证主页照片", dataType="String", required = true)
    @NotBlank(message = "行驶证主页照片不能为空")
    private String licenceImgMain;
    @ApiModelProperty(value = "行驶证副业正面照片", dataType="String", required = true)
    @NotBlank(message = "行驶证副业正面照片不能为空")
    private String licenceImgSecond;
    @ApiModelProperty(value = "行驶证副业背面照片", dataType="String", required = true)
    @NotBlank(message = "行驶证副业背面照片不能为空")
    private String licenceImgSecondBack;
    @ApiModelProperty(value = "道路运输许可证图片地址", dataType="String", required = true)
    @NotBlank(message = "道路运输许可证图片地址不能为空")
    private String transportLicenceImg;

    @ApiModelProperty(value = "行驶证有效期开始时间")
    private String drivingLicenseBeginTime;
    @ApiModelProperty(value = "行驶证有效期结束时间", required = true)
    @NotBlank(message = "行驶证有效期结束时间不能为空")
    private String drivingLicenseEndTime;
    @ApiModelProperty(value = "运输证有效期开始时间")
    private String transportationLicenseBeginTime;
    @ApiModelProperty(value = "运输证有效期结束时间")
    private String transportationLicenseEndTime;

    @ApiModelProperty(value = "挂车牌号")
    private String truckNo2;
    @ApiModelProperty("挂车行驶证主页")
    private String licenceImgMain2;
    @ApiModelProperty("挂车行驶证副页")
    private String licenceImgSecond2;
    @ApiModelProperty("挂车行驶证副页背面")
    private String licenceImgSecond2Back;
    @ApiModelProperty("挂车年检有效期至")
    private String licenceImgMain2EndTime;
    @ApiModelProperty("挂车道路运输许可证编号")
    private String roadTransportCertificateNo2;
    @ApiModelProperty("挂车道路运输许可证图片地址")
    private String transportLicenceImg2;

    @ApiModelProperty(value = "车辆燃料类型 1：柴油 2 天然气 3其他 4新能源/电", dataType="Integer", required = true)
    @NotNull(message = "车辆燃料类型不能为空")
    private Integer powerType;
    @ApiModelProperty(value = "使用性质", required = true)
    @NotBlank(message = "使用性质不能为空")
    private String useNature;
    @ApiModelProperty(value = "车辆识别代码", required = true)
    @NotBlank(message = "车辆识别代码不能为空")
    private String identifyCode;
    @ApiModelProperty(value = "行驶证发证机关", required = true)
    @NotBlank(message = "行驶证发证机关不能为空")
    private String licenceIssueOrganization;
    @ApiModelProperty(value = "注册日期", required = true)
    @NotBlank(message = "注册日期不能为空")
    private String registerDate;
    @ApiModelProperty(value = "行驶证发证日期", required = true)
    @NotBlank(message = "行驶证发证日期不能为空")
    private String licenceIssueDate;

}
