package com.clx.performance.service.impl;

import com.clx.performance.dao.breakcontract.BreakContractSettlementDriverDao;
import com.clx.performance.enums.BreakContractSettlementDriverEnum;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.model.breakcontract.BreakContractSettlementDriver;
import com.clx.performance.service.TempService;
import com.clx.performance.service.settle.SettlementService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class TempServiceImpl implements TempService {

    @Autowired
    private SettlementService settlementService;

    @Autowired
    private BreakContractSettlementDriverDao breakContractSettlementDriverDao;

    @Override
    public void updateInvoiceType(String childNo, Integer invoiceType) {

        settlementService.updateSettlementDetailInvoiceType(childNo, invoiceType);

    }

    @Override
    public void updateBreakContractDriverSettlementFinish(String settlementNo) {
        BreakContractSettlementDriver settlement = breakContractSettlementDriverDao.selectBySettlementNo(settlementNo).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        settlement.setSettleStatus(BreakContractSettlementDriverEnum.SettleStatus.YES.getCode());
    }

}
