package com.clx.performance.component;

import cn.hutool.core.util.StrUtil;
import com.clx.performance.constant.RedisConstants;
import com.clx.performance.dao.OrderGoodsDriverTruckDao;
import com.clx.performance.model.OrderGoodsDriverTruck;
import com.msl.common.base.Optional;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.stream.Collectors;


@Slf4j
@Component
@AllArgsConstructor
public class GoodsOrderTruckRecordComponent {

    private final RedisTemplate<String, String> redisTemplate;

    private final OrderGoodsDriverTruckDao orderGoodsDriverTruckDao;


    public void saveTruckRecord(String orderGoodsNo, List<String> truckList) {
        redisTemplate.opsForSet().add(RedisConstants.ORDER_GOODS_TRUCK_RECORD + orderGoodsNo, truckList.toArray(new String[]{}));
        redisTemplate.opsForSet().add(RedisConstants.ORDER_GOODS_RECORD, RedisConstants.ORDER_GOODS_TRUCK_RECORD + orderGoodsNo);
    }

    //删除货单下的所有车牌号
    public void deleteTruckRecord(String orderGoodsNo) {
        redisTemplate.delete(RedisConstants.ORDER_GOODS_TRUCK_RECORD + orderGoodsNo);
        //redisTemplate.opsForSet().remove(RedisConstants.ORDER_GOODS_TRUCK_RECORD + orderGoodsNo,);
        redisTemplate.opsForSet().remove(RedisConstants.ORDER_GOODS_RECORD, RedisConstants.ORDER_GOODS_TRUCK_RECORD + orderGoodsNo);
    }

    //删除货单下的指定车牌号
    public void deleteTruckRecord(String orderGoodsNo, String truckNo) {
        redisTemplate.opsForSet().remove(RedisConstants.ORDER_GOODS_TRUCK_RECORD + orderGoodsNo, truckNo);
    }

    //公开
    public Set<String> getPublicTruckList() {
        Set<String> orderGoodsList = redisTemplate.opsForSet().members(RedisConstants.ORDER_GOODS_RECORD);
        if (orderGoodsList == null || orderGoodsList.isEmpty()) {
            return null;
        }

        return redisTemplate.opsForSet().union(orderGoodsList);
    }

    //定向
    public List<String> getPrivateTruckList(String orderGoodsNo, Long userNo) {
        Optional<List<OrderGoodsDriverTruck>> optional = orderGoodsDriverTruckDao.selectListByDriverUserNo(userNo);
        if (!optional.isPresent()) {
            return null;
        }
        List<String> truckList = optional.get().stream().map(OrderGoodsDriverTruck::getTruckNo).collect(Collectors.toList());
        truckList.retainAll(redisTemplate.opsForSet().members(RedisConstants.ORDER_GOODS_TRUCK_RECORD + orderGoodsNo));
        return truckList;

    }
}
