package com.clx.performance.sqlProvider.vehiclewarn;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.enums.vehiclewarn.VehicleWarnInfoEnum;
import com.clx.performance.param.pc.vehiclewarn.PageVehicleWarnInfoParam;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

import java.util.Objects;

public class VehicleWarnInfoSqlProvider {

    private static final String TABLE = "vehicle_warn_info";

    public String pageByParam(@Param("page") Page page, @Param("param") PageVehicleWarnInfoParam param) {

        return new SQL(){{

            SELECT("*");
            FROM(TABLE);
            if (StringUtils.isNotBlank(param.getWarnName())) {WHERE("warn_name like CONCAT('%', #{param.warnName},'%')");}
            if (StringUtils.isNotBlank(param.getChildNo())) {WHERE("child_no = #{param.childNo}");}
            if (Objects.nonNull(param.getWarnType())) {WHERE("warn_type = #{param.warnType}");}
            if (Objects.nonNull(param.getWarnLevel())) {WHERE("warn_level = #{param.warnLevel}");}
            if (Objects.nonNull(param.getStatus())) {

                if (Objects.equals(param.getStatus(), VehicleWarnInfoEnum.Status.RESOLVE.getCode())) {
                    WHERE("status = #{param.status}");
                }
                else if (Objects.equals(param.getStatus(), VehicleWarnInfoEnum.Status.INIT.getCode())) {
                    WHERE("(status = 1 and (suspend_time is null or suspend_time < now()))");
                }
                else {
                    WHERE("(status = 1 and(suspend_time is not null and suspend_time > now()))");
                }

            }

            if (StringUtils.isNotBlank(param.getSendAddress())) {WHERE("send_address like CONCAT('%',#{param.sendAddress},'%')");}
            if (StringUtils.isNotBlank(param.getReceiveAddress())) {WHERE("receive_address like CONCAT('%',#{param.receiveAddress},'%')");}

            if (StringUtils.isNotBlank(param.getBeginTime())) {WHERE("create_time >= #{param.beginTime}");}
            if (StringUtils.isNotBlank(param.getEndTime())) {WHERE("create_time <= #{param.endTime}");}

            ORDER_BY("id desc");
        }}.toString();
    }

}
