package com.clx.performance.job.settlement;

import com.clx.performance.dao.OrderChildSyncTransportInvoiceRecordDao;
import com.clx.performance.dao.settle.OrderChildSyncTransportRecordDao;
import com.clx.performance.dao.settle.SettlementOwnerDetailDao;
import com.clx.performance.model.OrderChildSyncTransportInvoiceRecord;
import com.clx.performance.model.settle.OrderChildSyncTransportRecord;
import com.clx.performance.model.settle.SettlementOwnerDetail;
import com.clx.performance.service.settle.SettlementMqService;
import com.msl.common.job.JobLog;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Service
@AllArgsConstructor

public class SettlementJob {
    private final OrderChildSyncTransportInvoiceRecordDao orderChildSyncTransportInvoiceRecordDao;

    private final SettlementMqService settlementMqService;
    private final SettlementOwnerDetailDao settlementOwnerDetailDao;
    private final OrderChildSyncTransportRecordDao orderChildSyncTransportRecordDao;

    /**
     * 同步无车承运运单开票类型
     */
    @XxlJob("settlementInvoiceTypeSync")
    public void settlementInvoiceTypeSync() {
        List<OrderChildSyncTransportInvoiceRecord> recordList = orderChildSyncTransportInvoiceRecordDao
                .selectListForJob();
        log.info("待同步无车承运运单状态，size:{}", recordList.size());
        if (recordList.isEmpty()) {return;}

        for (OrderChildSyncTransportInvoiceRecord item : recordList) {

            settlementMqService.invoiceTypeSync(item.getChildNo());
        }

        orderChildSyncTransportInvoiceRecordDao.deleteByKeys(
                recordList.stream().map(item->item.getId()).collect(Collectors.toList()));
    }

    /**
     * 同步无车承运运单开票状态
     */
    @XxlJob("settlementInvoiceStatusSync")
    public void settlementInvoiceStatusSync() {
        try {
            List<SettlementOwnerDetail> list = settlementOwnerDetailDao.listInvoiceStatusSync();
            log.info("待同步无车承运运单开票状态, size:{}", list.size());
            if (list.isEmpty()) {return;}

            for (SettlementOwnerDetail item : list) {
                settlementMqService.invoiceStatusSync(item.getChildNo());
            }
        } catch (Exception e) {
            log.warn("同步无车承运运单开票状态失败，异常原因:{}", ExceptionUtils.getStackTrace(e));
            JobLog.error("同步无车承运运单开票状态失败，异常原因=====================", e);
        }
    }

    /**
     * 同步无车承运运单支付状态
     */
    @XxlJob("settlementPayStatusSync")
    public void settlementPayStatusSync() {
        try {
            List<OrderChildSyncTransportRecord> list = orderChildSyncTransportRecordDao.selectListForJob();

            log.info("待同步无车承运运单支付状态, size:{}", list.size());
            if (list.isEmpty()) {return;}

            for (OrderChildSyncTransportRecord item : list) {

                settlementMqService.payStatusSync(item.getChildNo());
            }
        } catch (Exception e) {
            log.warn("同步无车承运运单支付状态失败，异常原因:{}", ExceptionUtils.getStackTrace(e));
            JobLog.error("同步无车承运运单支付状态失败，异常原因=====================", e);
        }
    }

}
