package com.clx.performance.vo.pc.broker;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.math.BigDecimal;

@Getter
@Setter
@ToString
@NoArgsConstructor
public class OpenOrderDTO implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "货单编号", example = "12020083116861267", required = true, dataType = "String")
    private String sourceOrderNo;

    @ApiModelProperty(value = "发布货源时间", example = "2023-01-01 00:00:00", required = true, dataType = "String")
    private String publishTime;
    @ApiModelProperty(value = "最晚装货时间", example = "2023-01-01 00:00:00", required = true, dataType = "String")
    private String extractTime;
    @ApiModelProperty(value = "司机最晚到达时间", example = "2023-01-01 00:00:00", required = true, dataType = "String")
    private String arriveTime;

    @ApiModelProperty(value = "总货物数量", example = "32.12", required = true, dataType = "String")
    private BigDecimal goodsAmount;
    @ApiModelProperty(value = "货物名称", example = "原煤", required = true, dataType = "String")
    private String goodsName;
    @ApiModelProperty(value = "货物运费单价（分）", example = "3212", required = true, dataType = "Integer")
    private Integer transPrice;
    @ApiModelProperty(value = "货物价值（分）", example = "3212", required = true, dataType = "Integer")
    private Integer goodsPrice;

    @ApiModelProperty(value = "发货单位", example = "发货单位", required = true, dataType = "String")
    private String sendCompany;
    @ApiModelProperty(value = "货源所在详细地址", example = "货源所在详细地址", required = true, dataType = "String")
    private String sendAddress;
    @ApiModelProperty(value = "发货人姓名", example = "张三", required = true, dataType = "String")
    private String sendName;
    @ApiModelProperty(value = "收货人所在详细地址", example = "收货人所在详细地址", required = true, dataType = "String")
    private String receiveAddress;
    @ApiModelProperty(value = "收货单位", example = "收货单位", required = true, dataType = "String")
    private String receiveCompany;
    @ApiModelProperty(value = "收货人姓名", example = "张三", required = true, dataType = "String")
    private String receiveName;

    @ApiModelProperty(value = "发货所在省份", required = true)
    private String sendProvince;
    @ApiModelProperty(value = "发货所在城市", required = true)
    private String sendCity;
    @ApiModelProperty(value = "发货所在区县", required = true)
    private String sendCounty;
    @ApiModelProperty(value = "发货所在乡镇", required = true)
    private String sendTown;
    @ApiModelProperty(value = "发货联系人手机号", required = true)
    private String sendMobile;
    @ApiModelProperty(value = "发货地址经度", required = true)
    private String loadLongitude;
    @ApiModelProperty(value = "发货地址纬度", required = true)
    private String loadLatitude;
    @ApiModelProperty(value = "收货人所在省", required = true)
    private String receiveProvince;
    @ApiModelProperty(value = "收货人所在城市", required = true)
    private String receiveCity;
    @ApiModelProperty(value = "收货人所在区县", required = true)
    private String receiveCounty;
    @ApiModelProperty(value = "收货人所在乡镇", required = true)
    private String receiveTown;
    @ApiModelProperty(value = "收货联系人手机号", required = true)
    private String receiveMobile;
    @ApiModelProperty(value = "收货地址经度", required = true)
    private String unloadLongitude;
    @ApiModelProperty(value = "收货地址纬度", required = true)
    private String unloadLatitude;

}
