package com.clx.performance.vo.pc.broker;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;

@Getter
@Setter
@ToString
@NoArgsConstructor
public class OpenOrderChildDTO {

    private String sourceChildNo;
    @ApiModelProperty(value = "源货单编号", example = "1234", required = true, dataType = "String")
    private String sourceGoodsNo;
    @ApiModelProperty(value = "源订单编号", example = "1234", required = true, dataType = "String")
    private String sourceOrderNo;
    @ApiModelProperty(value = "源结算单编号", example = "1234", required = true, dataType = "String")
    private String sourceSettlementNo;

    @ApiModelProperty(value = "运费单价（分/吨）", example = "162", required = true, dataType = "Integer")
    private Integer freightPrice;
    @ApiModelProperty(value = "运费（分）", example = "162", required = true, dataType = "Integer")
    private Integer freight;
    @ApiModelProperty(value = "司机运费（分）",  example = "123", dataType = "Integer")
    private Integer driverFreight;
    @ApiModelProperty(value = "司机运费单价（分/吨）",  example = "123", dataType = "Integer")
    private Integer driverFreightPrice;
    @ApiModelProperty(value = "开票金额（分）", example = "162", required = true, dataType = "Integer")
    private Integer invoiceFreight;
    @ApiModelProperty(value = "亏吨扣款（分）",  example = "123", dataType = "Integer")
    private Integer lossFee;
    @ApiModelProperty(value = "货损单价（分/吨）",  example = "123", dataType = "Integer")
    private Integer lossFeePrice;

    @ApiModelProperty(value = "发货皮重（吨）")
    private BigDecimal sendTare;
    @ApiModelProperty(value = "发货毛重（吨）")
    private BigDecimal sendRough;
    @ApiModelProperty(value = "发货净重（吨）")
    private BigDecimal sendNet;

    @ApiModelProperty(value = "接单时间")
    private String payTime;
    @ApiModelProperty(value = "装车时间")
    private String loadTime;
    @ApiModelProperty(value = "卸车时间")
    private String unloadTime;
    @ApiModelProperty(value = "运单完成时间", example = "2020-02-02 10:10:10", required = true, dataType = "String")
    private String payFinishedTime;

    @ApiModelProperty(value = "收货皮重（吨）")
    private BigDecimal receiveTare;
    @ApiModelProperty(value = "收货毛重（吨）")
    private BigDecimal receiveRough;
    @ApiModelProperty(value = "收货净重（吨）")
    private BigDecimal receiveNet;

    @ApiModelProperty(value = "备注", example = "", required = true, dataType = "String")
    private String remark;

}
