package com.clx.performance.param.pc.carrier;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;

import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @ClassName UpdatePerformanceProgressParam
 * @Description
 * @Author kavin
 * @Date 2024/7/16 10:29
 * @Version 1.0
 */

@Getter
@Setter
public class UpdatePerformanceProgressParam {


    @NotNull(message = "id不能为空")
    @Schema(description="id")
    private Integer id;


    @Schema(description="今日预计完成吨数")
    private BigDecimal todayExpectComplete;


    @Schema(description="交易要求到站时间")
    private String tradeRequireArriveStationTime;


    @Schema(description="物流预计到站时间")
    private String transportExpectArriveStationTime;


    @Schema(description="异常备注")
    private String abnormalRemark;

    @Schema(description="履约异常原因")
    private String performanceAbnormalReason;

    @Schema(description="调度备注/跟进措施")
    private String dispatchFollow;
}
