package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author kavin
 * Date 2024-10-22
 * Time 10:38
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("order_child_exception_report")
public class OrderChildExceptionReport implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("report_no")
    @Schema(description="异常上报编号")
    private String reportNo;

    @TableField("third_report_no")
    @Schema(description="三方异常上报编号")
    private String thirdReportNo;

    @TableField("source")
    @Schema(description="来源")
    private Integer source;

    @TableField("exception_category")
    @Schema(description="异常类别")
    private String exceptionCategory;

    @TableField("exception_type")
    @Schema(description="异常类型")
    private String exceptionType;

    @TableField("truck_no_or_mobile")
    @Schema(description="车牌号/手机号")
    private String truckNoOrMobile;

    @TableField("child_no")
    @Schema(description="运单编号")
    private String childNo;

    @TableField("status")
    @Schema(description="状态：1：待处理  2：申诉中  3：已处理  4：已撤回")
    private Integer status;

    @TableField("deduction_amount")
    @Schema(description="扣罚金额")
    private BigDecimal deductionAmount;

    @TableField("report_time")
    @Schema(description="异常上报时间")
    private LocalDateTime reportTime;

    @TableField("reason")
    @Schema(description="异常原因描述")
    private String reason;


    @TableField("picture_url")
    @Schema(description="图片")
    private String pictureUrl;

    @TableField("video_url")
    @Schema(description="视频")
    private String videoUrl;

    @TableField("deal_user_code")
    @Schema(description="处理人用户编码")
    private Long dealUserCode;

    @TableField("deal_user")
    @Schema(description="处理人用户姓名")
    private String dealUser;

    @TableField("deal_time")
    @Schema(description="处理时间")
    private LocalDateTime dealTime;

    @TableField("deal_result")
    @Schema(description="处理结果")
    private Integer dealResult;

    @TableField("transfer_driver_break_contract")
    @Schema(description="是否转司机违约  1:是")
    private Integer transferDriverBreakContract;

    @TableField("create_time")
    @Schema(description="创建时间")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @Schema(description="修改时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
