/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent;

import cn.com.infosec.netsign.agent.NetSignAgent;
import cn.com.infosec.netsign.agent.NetSignAgentRes;
import cn.com.infosec.netsign.agent.NetSignAgentUtil;
import cn.com.infosec.netsign.agent.NetSignResult;
import cn.com.infosec.netsign.agent.NetSignService;
import cn.com.infosec.netsign.agent.exception.NetSignAgentException;
import cn.com.infosec.netsign.agent.exception.ServerProcessException;
import cn.com.infosec.netsign.agent.newcommunitor.CommunitorManager;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.NSMessageOpt;
import cn.com.infosec.netsign.crypto.util.Base64;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class NSSAgent
extends NetSignAgent {
    public static String KEYTYPE_SM2 = "SM2";
    public static String KEYTYPE_RSA = "RSA";

    public static int initialize(NetSignService[] services, boolean poolFlag) {
        if (services == null || services.length == 0) {
            return -1026;
        }
        NetSignAgentRes.setUseConnectionPool(poolFlag);
        if (poolFlag) {
            NetSignAgentRes.setMaxPoolSize(services[0].getPoolSize());
        }
        if (cm == null) {
            cm = new CommunitorManager(false);
        }
        int i = 0;
        int length = services.length;
        while (i < length) {
            cm.addService(services[i]);
            ++i;
        }
        ExtendedConfig.setEncoding("GBK");
        return 1;
    }

    public static String[] generatedKeyPair(String keyLable, String keyType, boolean isCover) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("NSSGenKeyPairProcessor");
        if (keyLable == null || keyLable.equals("")) {
            throw new NetSignAgentException("Parameter error: keylable is null.");
        }
        req.setBankID(keyLable);
        if (keyType == null || keyType.equals("")) {
            throw new NetSignAgentException("Parameter error: keyType is null.");
        }
        req.setSignCertType(keyType);
        req.setTransCert(isCover);
        NSMessageOpt res = NSSAgent.sendMsgAndCheck(req);
        String[] result = NetSignAgentUtil.genKeyPairResult(res);
        NSSAgent.freeObjects(req, res);
        return result;
    }

    public static String[] generatedSessionKeyPair(String encKeyLable, String keyType) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("NSSGenKeyPairProcessor");
        if (keyType == null || keyType.equals("")) {
            throw new NetSignAgentException("Parameter error: keyType is null.");
        }
        req.setSignCertType(keyType);
        req.setEncCertDN(encKeyLable);
        NSMessageOpt res = NSSAgent.sendMsgAndCheck(req);
        String[] result = NetSignAgentUtil.genKeyPairResult(res);
        NSSAgent.freeObjects(req, res);
        return result;
    }

    public static List getKeyLableList() throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("NSSGetKeyPairListProcessor");
        NSMessageOpt res = NSSAgent.sendMsgAndCheck(req);
        ArrayList<String> list = null;
        String kpls = res.getSignCertDN();
        if (kpls != null && !kpls.equals("")) {
            list = new ArrayList<String>();
            String[] pieces = kpls.split("\\$");
            int i = 0;
            while (i < pieces.length) {
                if (!pieces[i].trim().equals("")) {
                    list.add(pieces[i].trim());
                }
                ++i;
            }
        }
        NSSAgent.freeObjects(req, res);
        return list;
    }

    public static int deleteKeyPair(String keyLable) throws NetSignAgentException, ServerProcessException {
        int result = 1;
        try {
            NSMessage req = NetSignAgentUtil.createMessage("NSSDeleteKeyPairProcessor");
            if (keyLable == null || keyLable.equals("")) {
                throw new NetSignAgentException("Parameter error: keylable is null.");
            }
            req.setBankID(keyLable);
            NSMessageOpt res = NSSAgent.sendMsgAndCheck(req);
            NSSAgent.freeObjects(req, res);
        }
        catch (NetSignAgentException e1) {
            result = e1.getErrorCode();
            throw e1;
        }
        catch (ServerProcessException e2) {
            result = e2.getErrorCode();
            throw e2;
        }
        return result;
    }

    public static int deleteKeyPairFromAllService(String keyLable, HashMap resultsMap) {
        int result = 1;
        NSMessage req = NetSignAgentUtil.createMessage("NSSDeleteKeyPairProcessor");
        if (keyLable == null || keyLable.equals("")) {
            result = -1050;
        }
        if (resultsMap == null) {
            result = -1050;
        }
        if (result < 0) {
            return result;
        }
        req.setBankID(keyLable);
        NSMessageOpt[] resps = cm.sendAll(req);
        int[] results = new int[resps.length];
        int i = 0;
        while (i < results.length) {
            if (resps[i] != null) {
                results[i] = resps[i].getResult();
                String res = String.valueOf(results[i]);
                if (resps[i].getErrMsg() != null && !resps[i].getErrMsg().equals("")) {
                    res = String.valueOf(res) + ":" + resps[i].getErrMsg();
                }
                resultsMap.put(resps[i].getAddress(), res);
            }
            ++i;
        }
        return result;
    }

    public static String[] exportKeyPair(String keyLable, boolean isEncKeyPair) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("NSSExportKeyPairProcessor");
        if (keyLable == null || keyLable.equals("")) {
            throw new NetSignAgentException("Parameter error: keylable is null.");
        }
        req.setBankID(keyLable);
        req.setUsedTSA(isEncKeyPair);
        NSMessageOpt res = NSSAgent.sendMsgAndCheck(req);
        String[] kps = NetSignAgentUtil.genKeyPairResult(res);
        NSSAgent.freeObjects(req, res);
        return kps;
    }

    public static String[] exportKeyPair(String keyLable) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("NSSExportKeyPairProcessor");
        if (keyLable == null || keyLable.equals("")) {
            throw new NetSignAgentException("Parameter error: keylable is null.");
        }
        req.setBankID(keyLable);
        req.setUsedTSA(true);
        NSMessageOpt res = NSSAgent.sendMsgAndCheck(req);
        String[] kps = NetSignAgentUtil.genKeyPairResult(res);
        NSSAgent.freeObjects(req, res);
        return kps;
    }

    public static int importKeyPair(String keyLable, String[] keypair, boolean isCover) throws NetSignAgentException, ServerProcessException {
        int result = 1;
        try {
            NSMessage req = NetSignAgentUtil.createMessage("NSSImportKeyPairProcessor");
            if (keyLable == null || keyLable.equals("")) {
                throw new NetSignAgentException("Parameter error: keylable is null.");
            }
            req.setBankID(keyLable);
            if (keypair[0] == null || keypair[0].equals("")) {
                throw new NetSignAgentException("Parameter error: publickey is null.");
            }
            if (keypair[1] == null || keypair[1].equals("")) {
                throw new NetSignAgentException("Parameter error: privatekey is null.");
            }
            req.setCryptoText((String.valueOf(keypair[0]) + ":" + keypair[1]).getBytes());
            req.setTransCert(isCover);
            req.setUsedTSA(true);
            NSMessageOpt res = NSSAgent.sendMsgAndCheck(req);
            NSSAgent.freeObjects(req, res);
        }
        catch (NetSignAgentException e1) {
            result = e1.getErrorCode();
            throw e1;
        }
        catch (ServerProcessException e2) {
            result = e2.getErrorCode();
            throw e2;
        }
        return result;
    }

    public static int importKeyPair(String keyLable, String[] keypair, boolean isCover, boolean isEncKeyPair) throws NetSignAgentException, ServerProcessException {
        int result = 1;
        try {
            NSMessage req = NetSignAgentUtil.createMessage("NSSImportKeyPairProcessor");
            if (keyLable == null || keyLable.equals("")) {
                throw new NetSignAgentException("Parameter error: keylable is null.");
            }
            req.setBankID(keyLable);
            if (keypair[0] == null || keypair[0].equals("") || keypair[1] == null || keypair[1].equals("")) {
                throw new NetSignAgentException("Parameter error: keypair input illegality.");
            }
            if (keypair[0] != null && keypair[0].length() == 3) {
                req.setSignCertType(keypair[0].toUpperCase());
                keypair[0] = "";
            } else if (keypair[1] != null && keypair[1].length() == 3) {
                req.setSignCertType(keypair[1].toUpperCase());
                keypair[1] = "";
            }
            req.setCryptoText((String.valueOf(keypair[0]) + ":" + keypair[1]).getBytes());
            req.setTransCert(isCover);
            req.setUsedTSA(isEncKeyPair);
            NSMessageOpt res = NSSAgent.sendMsgAndCheck(req);
            NSSAgent.freeObjects(req, res);
        }
        catch (NetSignAgentException e1) {
            result = e1.getErrorCode();
            throw e1;
        }
        catch (ServerProcessException e2) {
            result = e2.getErrorCode();
            throw e2;
        }
        return result;
    }

    public static int importKeyPair2AllService(String keyLable, String[] keypair, boolean isCover, HashMap resultsMap) {
        int result = 1;
        NSMessage req = NetSignAgentUtil.createMessage("NSSImportKeyPairProcessor");
        if (keyLable == null || keyLable.equals("")) {
            result = -1050;
        }
        req.setBankID(keyLable);
        if (keypair[0] == null || keypair[0].equals("")) {
            result = -1050;
        }
        if (keypair[1] == null || keypair[1].equals("")) {
            result = -1050;
        }
        if (resultsMap == null) {
            result = -1050;
        }
        if (result < 0) {
            return result;
        }
        req.setCryptoText((String.valueOf(keypair[0]) + ":" + keypair[1]).getBytes());
        req.setTransCert(isCover);
        req.setUsedTSA(true);
        NSMessageOpt[] resps = cm.sendAll(req);
        int[] results = new int[resps.length];
        int i = 0;
        while (i < results.length) {
            if (resps[i] != null) {
                results[i] = resps[i].getResult();
                String res = String.valueOf(results[i]);
                if (resps[i].getErrMsg() != null && !resps[i].getErrMsg().equals("")) {
                    res = String.valueOf(res) + ":" + resps[i].getErrMsg();
                }
                resultsMap.put(resps[i].getAddress(), res);
            }
            ++i;
        }
        return result;
    }

    public static int importKeyPair2AllService(String keyLable, String[] keypair, boolean isCover, HashMap resultsMap, boolean isEncKeyPair) {
        int result = 1;
        NSMessage req = NetSignAgentUtil.createMessage("NSSImportKeyPairProcessor");
        if (keyLable == null || keyLable.equals("")) {
            result = -1050;
        }
        if (keypair[0] == null || keypair[0].equals("") || keypair[1] == null || keypair[1].equals("")) {
            result = -1050;
        }
        if (keypair[0] != null && keypair[0].length() == 3) {
            req.setSignCertType(keypair[0].toUpperCase());
            keypair[0] = "";
        } else if (keypair[1] != null && keypair[1].length() == 3) {
            req.setSignCertType(keypair[1].toUpperCase());
            keypair[1] = "";
        }
        req.setBankID(keyLable);
        if (resultsMap == null) {
            result = -1050;
        }
        if (result < 0) {
            return result;
        }
        req.setCryptoText((String.valueOf(keypair[0]) + ":" + keypair[1]).getBytes());
        req.setTransCert(isCover);
        req.setUsedTSA(isEncKeyPair);
        NSMessageOpt[] resps = cm.sendAll(req);
        int[] results = new int[resps.length];
        int i = 0;
        while (i < results.length) {
            if (resps[i] != null) {
                results[i] = resps[i].getResult();
                String res = String.valueOf(results[i]);
                if (resps[i].getErrMsg() != null && !resps[i].getErrMsg().equals("")) {
                    res = String.valueOf(res) + ":" + resps[i].getErrMsg();
                }
                resultsMap.put(resps[i].getAddress(), res);
            }
            ++i;
        }
        return result;
    }

    public static String rawSign(byte[] plainText, String keyLable, String algHash) throws NetSignAgentException, ServerProcessException {
        if (keyLable == null || keyLable.equals("")) {
            throw new NetSignAgentException("Parameter error: keylable is null.");
        }
        NSMessage req = NetSignAgentUtil.createMessage("NSSRAWSignProcessor");
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setPlainText(plainBytes);
        req.setBankID(keyLable);
        req.setDigestAlg(algHash);
        NSMessageOpt res = NSSAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.signatureResult(res);
        NSSAgent.freeObjects(req, res);
        return result.getStringResult("Base64_Signed_Text");
    }

    public static String rawSignWithSessionKey(byte[] plainText, String encKeyLabel, String[] keyPair, String keyType, String algHash) throws NetSignAgentException, ServerProcessException {
        if (keyPair == null || keyPair.length == 0) {
            throw new NetSignAgentException("Parameter error: keyPair is null.");
        }
        NSMessage req = NetSignAgentUtil.createMessage("NSSRAWSignProcessor");
        byte[] plainBytes = plainText;
        req.setPlainText(plainBytes);
        req.setEncCertDN(encKeyLabel);
        req.setSignCertType(keyType);
        req.setDigestAlg(algHash);
        req.setCryptoText((String.valueOf(keyPair[0]) + ":" + keyPair[1]).getBytes());
        NSMessageOpt res = NSSAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.signatureResult(res);
        NSSAgent.freeObjects(req, res);
        return result.getStringResult("Base64_Signed_Text");
    }

    public static int rawSignVerifyWithSessionKey(byte[] plainText, String signedData, String[] keyPair, String keyType, String algHash) throws NetSignAgentException, ServerProcessException {
        int result = 1;
        try {
            NSMessage req = NetSignAgentUtil.createMessage("NSSRAWVerifyProcessor");
            plainText = NetSignAgentUtil.checkAndZip(plainText, req);
            plainText = NetSignAgentUtil.checkAndEncrypt(plainText, req);
            byte[] signedBytes = NetSignAgentUtil.decode(signedData);
            req.setCryptoText(signedBytes);
            req.setPlainText(plainText);
            req.setBankName(String.valueOf(keyPair[0]) + ":" + keyPair[1]);
            req.setDigestAlg(algHash);
            req.setSignCertType(keyType);
            NSMessageOpt res = NSSAgent.sendMsgAndCheck(req);
            NetSignResult re = NetSignAgentUtil.rawVerifyResult(res);
            NSSAgent.freeObjects(req, res);
            result = re.getResult();
        }
        catch (NetSignAgentException e1) {
            result = e1.getErrorCode();
            throw e1;
        }
        catch (ServerProcessException e2) {
            result = e2.getErrorCode();
            throw e2;
        }
        return result;
    }

    public static int rawSignVerify(byte[] plainText, String signedData, String algHash, String pubkey) throws NetSignAgentException, ServerProcessException {
        int result = 1;
        try {
            NSMessage req = NetSignAgentUtil.createMessage("NSSRAWVerifyProcessor");
            plainText = NetSignAgentUtil.checkAndZip(plainText, req);
            plainText = NetSignAgentUtil.checkAndEncrypt(plainText, req);
            byte[] signedBytes = NetSignAgentUtil.decode(signedData);
            req.setCryptoText(signedBytes);
            req.setPlainText(plainText);
            req.setPublicKey(NetSignAgentUtil.getRSAPublicKey(Base64.decode(pubkey)));
            req.setDigestAlg(algHash);
            NSMessageOpt res = NSSAgent.sendMsgAndCheck(req);
            NetSignResult re = NetSignAgentUtil.rawVerifyResult(res);
            NSSAgent.freeObjects(req, res);
            result = re.getResult();
        }
        catch (NetSignAgentException e1) {
            result = e1.getErrorCode();
            throw e1;
        }
        catch (ServerProcessException e2) {
            result = e2.getErrorCode();
            throw e2;
        }
        return result;
    }

    public static int rawSignVerify(byte[] plainText, byte[] signedData, String algHash, String pubkey) throws NetSignAgentException, ServerProcessException {
        int result = 1;
        try {
            NSMessage req = NetSignAgentUtil.createMessage("NSSRAWVerifyProcessor");
            plainText = NetSignAgentUtil.checkAndZip(plainText, req);
            plainText = NetSignAgentUtil.checkAndEncrypt(plainText, req);
            req.setCryptoText(signedData);
            req.setPlainText(plainText);
            req.setPublicKey(NetSignAgentUtil.getRSAPublicKey(Base64.decode(pubkey)));
            req.setDigestAlg(algHash);
            NSMessageOpt res = NSSAgent.sendMsgAndCheck(req);
            NetSignResult re = NetSignAgentUtil.rawVerifyResult(res);
            NSSAgent.freeObjects(req, res);
            result = re.getResult();
        }
        catch (NetSignAgentException e1) {
            result = e1.getErrorCode();
            throw e1;
        }
        catch (ServerProcessException e2) {
            result = e2.getErrorCode();
            throw e2;
        }
        return result;
    }

    public static int rawSignVerifyByKeyLable(byte[] plainText, String signedData, String algHash, String keylable) throws NetSignAgentException, ServerProcessException {
        int result = 1;
        try {
            NSMessage req = NetSignAgentUtil.createMessage("NSSRAWVerifyProcessor");
            plainText = NetSignAgentUtil.checkAndZip(plainText, req);
            plainText = NetSignAgentUtil.checkAndEncrypt(plainText, req);
            byte[] signedBytes = NetSignAgentUtil.decode(signedData);
            req.setCryptoText(signedBytes);
            req.setPlainText(plainText);
            req.setBankID(keylable);
            req.setDigestAlg(algHash);
            NSMessageOpt res = NSSAgent.sendMsgAndCheck(req);
            NetSignResult re = NetSignAgentUtil.rawVerifyResult(res);
            NSSAgent.freeObjects(req, res);
            result = re.getResult();
        }
        catch (NetSignAgentException e1) {
            result = e1.getErrorCode();
            throw e1;
        }
        catch (ServerProcessException e2) {
            result = e2.getErrorCode();
            throw e2;
        }
        return result;
    }

    public static int rawSignVerifyByKeyLable(byte[] plainText, byte[] signedData, String algHash, String keylable) throws NetSignAgentException, ServerProcessException {
        int result = 1;
        try {
            NSMessage req = NetSignAgentUtil.createMessage("NSSRAWVerifyProcessor");
            plainText = NetSignAgentUtil.checkAndZip(plainText, req);
            plainText = NetSignAgentUtil.checkAndEncrypt(plainText, req);
            req.setCryptoText(signedData);
            req.setPlainText(plainText);
            req.setBankID(keylable);
            req.setDigestAlg(algHash);
            NSMessageOpt res = NSSAgent.sendMsgAndCheck(req);
            NetSignResult re = NetSignAgentUtil.rawVerifyResult(res);
            NSSAgent.freeObjects(req, res);
            result = re.getResult();
        }
        catch (NetSignAgentException e1) {
            result = e1.getErrorCode();
            throw e1;
        }
        catch (ServerProcessException e2) {
            result = e2.getErrorCode();
            throw e2;
        }
        return result;
    }

    public static String[] genP10(String certDN, String keyLable, String keyType, boolean isCover) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("NSSGenP10Processor");
        if (keyType == null || keyType.equals("")) {
            throw new NetSignAgentException("Parameter error: keyType is null ");
        }
        if (keyLable == null || keyLable.trim().equals("")) {
            throw new NetSignAgentException("Parameter error: keyLable is null ");
        }
        if (keyLable.contains("&")) {
            throw new NetSignAgentException("Parameter error: keyLable contains & ");
        }
        if (certDN == null || certDN.equals("")) {
            throw new NetSignAgentException("Parameter error: certDN is null ");
        }
        req.setSignCertDN(certDN);
        req.setBankID(keyLable);
        req.setSignCertType(keyType);
        req.setTransCert(isCover);
        NSMessageOpt res = NSSAgent.sendMsgAndCheck(req);
        String[] result = NetSignAgentUtil.genKeyPairResult(res);
        NSSAgent.freeObjects(req, res);
        return result;
    }
}

