/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.pkcs;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1OctetString;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.BERSequence;
import cn.com.infosec.asn1.BERTaggedObject;
import cn.com.infosec.asn1.DEREncodable;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.DERTaggedObject;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;

public class EncryptedData
extends ASN1Encodable {
    ASN1Sequence data;
    DERObjectIdentifier bagId;
    DERObject bagValue;

    public static EncryptedData getInstance(Object obj) {
        if (obj instanceof EncryptedData) {
            return (EncryptedData)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new EncryptedData((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory: " + obj.getClass().getName());
    }

    public EncryptedData(ASN1Sequence seq) {
        int version = ((DERInteger)seq.getObjectAt(0)).getValue().intValue();
        if (version != 0) {
            throw new IllegalArgumentException("sequence not version 0");
        }
        this.data = (ASN1Sequence)seq.getObjectAt(1);
    }

    public EncryptedData(DERObjectIdentifier contentType, AlgorithmIdentifier encryptionAlgorithm, DEREncodable content) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(contentType);
        v.add(encryptionAlgorithm.getDERObject());
        v.add(new BERTaggedObject(false, 0, content));
        this.data = new BERSequence(v);
    }

    public DERObjectIdentifier getContentType() {
        return (DERObjectIdentifier)this.data.getObjectAt(0);
    }

    public AlgorithmIdentifier getEncryptionAlgorithm() {
        return AlgorithmIdentifier.getInstance(this.data.getObjectAt(1));
    }

    public ASN1OctetString getContent() {
        if (this.data.size() == 3) {
            DERTaggedObject o = (DERTaggedObject)this.data.getObjectAt(2);
            return ASN1OctetString.getInstance(o.getObject());
        }
        return null;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new DERInteger(0));
        v.add(this.data);
        return new BERSequence(v);
    }
}

