package com.clx.performance.struct.breakcontract;

import com.clx.performance.enums.BreakContractSettlementDriverEnum;
import com.clx.performance.model.breakcontract.BreakContractDriverRecord;
import com.clx.performance.model.breakcontract.BreakContractSettlementDriverDetail;
import com.clx.performance.vo.pc.breakcontract.carrier.PageCarrierBreakContractSettlementDriverDetailVO;
import com.msl.common.utils.DateStructUtil;
import com.msl.common.utils.DateUtils;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Named;

import java.util.List;

@Mapper(componentModel = "spring", uses = DateStructUtil.class, imports = {BreakContractSettlementDriverEnum.class,  DateUtils.class})
public interface BreakContractSettlementDriverDetailStruct {


    @Named("toBaseVo")
    @Mapping(target = "breakContractPartyTypeMsg", expression = "java(BreakContractSettlementDriverEnum.BreakContractPartyType.getMsgByCode(detail.getBreakContractPartyType()))")
    PageCarrierBreakContractSettlementDriverDetailVO convert(BreakContractSettlementDriverDetail detail);

    @IterableMapping(qualifiedByName = "toBaseVo")
    List<PageCarrierBreakContractSettlementDriverDetailVO> covertToCarrierList(List<BreakContractSettlementDriverDetail> list);

    @Mapping(target = "breakContractRemark", source = "remark")
    BreakContractSettlementDriverDetail convert(BreakContractDriverRecord detail);

}
