package com.clx.performance.sqlProvider;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.param.pc.pageIntegralOrderParam;
import com.clx.performance.vo.pc.IntegralOrderVO;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

public class IntegralOrderSqlProvider {

    public String pageByParam(@Param("page") Page<IntegralOrderVO> page, @Param("param") pageIntegralOrderParam param) {
        return new SQL(){{

            SELECT(" id, order_goods_no, " +
                    " send_address_id, send_address, " +
                    " receive_address_id, receive_address, " +
                    " order_type, truck_echelon, " +
                    " date_format(create_time, '%Y-%m-%d %H:%i:%s') as createTime, " +
                    " date_format(modified_time, '%Y-%m-%d %H:%i:%s') as modifiedTime ");

            FROM("integral_order");

            if (StringUtils.isNotBlank(param.getOrderGoodsNo())) {WHERE("order_goods_no = #{param.orderGoodsNo}");}

            if (StringUtils.isNotBlank(param.getBeginTime())) {WHERE("create_time >= #{param.beginTime}");}
            if (StringUtils.isNotBlank(param.getEndTime())) {WHERE("create_time <= #{param.endTime}");}

            ORDER_BY("create_time desc");
        }}.toString();
    }

}
