package com.clx.performance.service.impl;


import com.clx.performance.dao.SeniorLogisticsManagerDao;
import com.clx.performance.model.SeniorLogisticsManager;
import com.clx.performance.service.SeniorLogisticsManagerService;
import com.clx.performance.struct.SeniorLogisticsManagerStruct;
import com.clx.performance.vo.pc.SeniorLogisticsManagerVO;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author kavin
 * Date 2023-09-17
 * Time 16:45
 */
@Service
@AllArgsConstructor
public class SeniorLogisticsManagerServiceImpl  implements SeniorLogisticsManagerService {

    private final SeniorLogisticsManagerDao seniorLogisticsManagerDao;



    private final SeniorLogisticsManagerStruct seniorLogisticsManagerStruct;

    /**
     * @Author kavin
     * @Description 获取高级物流经理下拉选
     * @Param []
     * @return
     **/
    @Override
    public List<SeniorLogisticsManagerVO> getList() {
        List<SeniorLogisticsManager> seniorLogisticsManagers = seniorLogisticsManagerDao.listAll();
        return seniorLogisticsManagerStruct.convert(seniorLogisticsManagers);
    }
}
