package com.clx.performance.service.impl;

import com.alibaba.fastjson.JSON;
import com.clx.performance.common.MqDelay;
import com.clx.performance.common.MqWrapper;
import com.clx.performance.constant.RabbitKeyOrderChildConstants;
import com.clx.performance.param.mq.OrderChildCancelMqParam;
import com.clx.performance.service.OrderChildMqService;
import com.clx.performance.vo.mq.OrderChildAddMqParam;
import com.clx.performance.vo.mq.OrderChildArriveReceiveAddressMqParam;
import com.clx.performance.vo.mq.OrderChildArriveSendAddressMqParam;
import com.clx.performance.vo.mq.OrderChildDriverConfirmMqParam;
import com.clx.performance.vo.mq.OrderChildLoadMqParam;
import com.clx.performance.vo.mq.OrderChildUnloadMqParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilder;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class OrderChildMqServiceImpl implements OrderChildMqService {

    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Override
    public void orderChildAdd(String childNo) {
        OrderChildAddMqParam mq = new OrderChildAddMqParam();
        mq.setChildNo(childNo);

        MqDelay<MqWrapper<OrderChildAddMqParam>> delay = new MqDelay<>(RabbitKeyOrderChildConstants.DEFAULT_EXCHANGE, RabbitKeyOrderChildConstants.ORDER_CHILD_ADD_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeyOrderChildConstants.DEFAULT_EXCHANGE, RabbitKeyOrderChildConstants.DEFAULT_DELAY_ROUTING_KEY, message);
    }

    @Override
    public void orderChildArriveSendAddress(String childNo) {
        OrderChildArriveSendAddressMqParam mq = new OrderChildArriveSendAddressMqParam();
        mq.setChildNo(childNo);

        MqDelay<MqWrapper<OrderChildArriveSendAddressMqParam>> delay = new MqDelay<>(RabbitKeyOrderChildConstants.DEFAULT_EXCHANGE, RabbitKeyOrderChildConstants.ORDER_CHILD_ARRIVE_SEND_ADDRESS_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeyOrderChildConstants.DEFAULT_EXCHANGE, RabbitKeyOrderChildConstants.DEFAULT_DELAY_ROUTING_KEY, message);
    }

    @Override
    public void orderChildArriveReceiveAddress(String childNo) {
        OrderChildArriveReceiveAddressMqParam mq = new OrderChildArriveReceiveAddressMqParam();
        mq.setChildNo(childNo);

        MqDelay<MqWrapper<OrderChildArriveReceiveAddressMqParam>> delay = new MqDelay<>(RabbitKeyOrderChildConstants.DEFAULT_EXCHANGE, RabbitKeyOrderChildConstants.ORDER_CHILD_ARRIVE_RECEIVE_ADDRESS_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeyOrderChildConstants.DEFAULT_EXCHANGE, RabbitKeyOrderChildConstants.DEFAULT_DELAY_ROUTING_KEY, message);
    }

    @Override
    public void orderChildDriverConfirm(String childNo) {
        OrderChildDriverConfirmMqParam mq = new OrderChildDriverConfirmMqParam();
        mq.setChildNo(childNo);

        MqDelay<MqWrapper<OrderChildDriverConfirmMqParam>> delay = new MqDelay<>(RabbitKeyOrderChildConstants.DEFAULT_EXCHANGE, RabbitKeyOrderChildConstants.ORDER_CHILD_DRIVER_CONFIRM_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeyOrderChildConstants.DEFAULT_EXCHANGE, RabbitKeyOrderChildConstants.DEFAULT_DELAY_ROUTING_KEY, message);
    }



    @Override
    public void orderChildLoad(String childNo) {
        OrderChildLoadMqParam mq = new OrderChildLoadMqParam();
        mq.setChildNo(childNo);
        mq.setRepeatStatus(0);

        MqDelay<MqWrapper<OrderChildLoadMqParam>> delay = new MqDelay<>(RabbitKeyOrderChildConstants.DEFAULT_EXCHANGE, RabbitKeyOrderChildConstants.ORDER_CHILD_LOAD_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeyOrderChildConstants.DEFAULT_EXCHANGE, RabbitKeyOrderChildConstants.DEFAULT_DELAY_ROUTING_KEY, message);
    }

    @Override
    public void orderChildUnload(String childNo) {
        OrderChildUnloadMqParam mq = new OrderChildUnloadMqParam();
        mq.setChildNo(childNo);
        mq.setRepeatStatus(0);

        MqDelay<MqWrapper<OrderChildUnloadMqParam>> delay = new MqDelay<>(RabbitKeyOrderChildConstants.DEFAULT_EXCHANGE, RabbitKeyOrderChildConstants.ORDER_CHILD_UNLOAD_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeyOrderChildConstants.DEFAULT_EXCHANGE, RabbitKeyOrderChildConstants.DEFAULT_DELAY_ROUTING_KEY, message);
    }

    @Override
    public void orderChildCancel(String childNo, Integer status, Integer opUserType, Long opUserNo, String opUserName) {
        OrderChildCancelMqParam mq = new OrderChildCancelMqParam();
        mq.setChildNo(childNo);
        mq.setStatus(status);
        mq.setOpUserType(opUserType);
        mq.setOpUserNo(opUserNo);
        mq.setOpUserName(opUserName);

        MqDelay<MqWrapper<OrderChildCancelMqParam>> delay = new MqDelay<>(RabbitKeyOrderChildConstants.DEFAULT_EXCHANGE, RabbitKeyOrderChildConstants.ORDER_CHILD_CANCEL_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeyOrderChildConstants.DEFAULT_EXCHANGE, RabbitKeyOrderChildConstants.DEFAULT_DELAY_ROUTING_KEY, message);
    }

}
