package com.clx.performance.mapper.collect;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.model.collect.CollectTruckLocation;
import com.clx.performance.param.app.collect.PageCollectTruckLocationParam;
import com.clx.performance.param.pc.carrier.CarrierPageCollectTruckLocationParam;
import com.clx.performance.sqlProvider.collect.CollectTruckLocationSqlProvider;
import com.clx.performance.vo.pc.collect.CollectTruckLocationVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;

/**
* @Author: aiqinguo
* @Description: 车辆位置上报
* @Date: 2023/09/18 11:34:50
* @Version: 1.0
*/

@Mapper
public interface CollectTruckLocationMapper extends BaseMapper<CollectTruckLocation> {
    /**
     * @see CollectTruckLocationSqlProvider#pageLocation(com.baomidou.mybatisplus.extension.plugins.pagination.Page, com.clx.performance.param.app.collect.PageCollectTruckLocationParam)
     */
    @SelectProvider(type = CollectTruckLocationSqlProvider.class, method = "pageLocation")
    IPage<CollectTruckLocationVO> pageLocation(@Param("page") Page<CollectTruckLocationVO> page, @Param("param") PageCollectTruckLocationParam param);

    /**
     * @see CollectTruckLocationSqlProvider#carrierPageLocation(com.baomidou.mybatisplus.extension.plugins.pagination.Page, com.clx.performance.param.pc.carrier.CarrierPageCollectTruckLocationParam)
     */
    @SelectProvider(type = CollectTruckLocationSqlProvider.class, method = "carrierPageLocation")
    IPage<CollectTruckLocationVO> carrierPageLocation(@Param("page") Page<CollectTruckLocationVO> page, @Param("param") CarrierPageCollectTruckLocationParam param);

}