package com.clx.performance.listener.settle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.clx.performance.common.MqWrapper;
import com.clx.performance.constant.RabbitKeySettlementConstants;
import com.clx.performance.service.settle.SettlementMqHandlerService;
import com.clx.performance.vo.mq.SettlementDetailAddMqParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @Author: 艾庆国
 * @Description: 计费明细新增 mq
 * @Date: 2023-10-20 11:45:08
 * @Version: 1.0
 */
@Slf4j
@Component
public class SettlementDetailAddListener {

    @Autowired
    private SettlementMqHandlerService settlementMqHandlerService;

    @RabbitListener(queues = RabbitKeySettlementConstants.SETTLEMENT_DETAIL_ADD_QUEUE)
    public void process(Message message) {
        try{
            log.info("结算-计费明细新增, message:{}", new String(message.getBody()));
            process(JSON.parseObject(new String(message.getBody()), new TypeReference<MqWrapper<SettlementDetailAddMqParam>>(){}).getData());
        }catch (Exception e){
            log.info("结算-计费明细新增 失败",e);
        }
    }

    private void process(SettlementDetailAddMqParam mq){

        settlementMqHandlerService.settlementDetailAdd(mq);

    }
}
