package com.clx.performance.listener.breakcontract;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.clx.performance.common.MqWrapper;
import com.clx.performance.constant.RabbitKeyBreakContractConstants;
import com.clx.performance.param.mq.BreakContractOwnerRuleAddMqParam;
import com.clx.performance.service.breakcontract.BreakContractMqHandlerService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @Author: 艾庆国
 * @Description: 违约规则新增 mq
 * @Date: 2023-10-20 11:45:08
 * @Version: 1.0
 */
@Slf4j
@Component
public class BreakContractOwnerRuleAddListener {

    @Autowired
    private BreakContractMqHandlerService breakContractMqHandlerService;

    @RabbitListener(queues = RabbitKeyBreakContractConstants.OWNER_RULE_ADD_QUEUE)
    public void process(Message message) {
        try{
            log.info("违约-货主违约规则创建, message:{}", new String(message.getBody()));
            process(JSON.parseObject(new String(message.getBody()), new TypeReference<MqWrapper<BreakContractOwnerRuleAddMqParam>>(){}).getData());
        }catch (Exception e){
            log.info("违约-货主违约规则创建 失败",e);
        }
    }

    private void process(BreakContractOwnerRuleAddMqParam mq){

        breakContractMqHandlerService.ownerRuleAdd(mq);

    }
}
