package com.clx.performance.feign;

import com.clx.performance.dto.payment.WalletResidueCardDTO;
import com.clx.user.param.thirdparty.payment.CarrierWalletSaveDTO;
import com.msl.common.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotNull;


@FeignClient(name = "payment-service")
@RequestMapping(value = "/payment-service")
public interface FeignPaymentService {

    /**
     * 获取钱包信息
     * @param wallet
     * @return
     */
    @GetMapping(value = "/walletCard/getWallet")
    Result<WalletResidueCardDTO> getWallet(@RequestParam("userCode") @NotNull(message = "用户钱包地址编号不可为空")Integer userCode);

}
