package com.clx.performance.extranal.user.impl;

import com.clx.performance.extranal.user.OwnerInfoService;
import com.clx.user.feign.OwnerInfoFeign;
import com.clx.user.vo.feign.OwnerInfoFeignVO;
import com.msl.common.base.Optional;
import com.msl.common.enums.ResultCodeEnum;
import com.msl.common.result.Result;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@Slf4j
@Service
@AllArgsConstructor
public class OwnerInfoServiceImpl implements OwnerInfoService {

    private final OwnerInfoFeign ownerInfoFeign;

    @Override
    public OwnerInfoFeignVO getOwnerInfo(Long userNo) {
        return Optional.ofNullable(ownerInfoFeign.getOwnerInfo(userNo))
                .filter(Result::succeed).map(item->item.getData()).orElseThrow(ResultCodeEnum.FAIL);
    }

}
