package com.clx.performance.enums;

public enum PayUnitTypeEnum {
	FREEZE(100,"冻结"),
	FREEZE_OWNER_DEPOSIT(101,"冻结货主保证金"),FREEZE_FREIGHT(102,"冻结货主运费"),FREEZE_DRIVER_DEPOSIT(103,"冻结司机保证金"),
	FREEZE_INSURANCE_FEE(104,"冻结货物担保"),FREEZE_PLATFORM_FEE(105,"冻结平台信息费"),FREEZE_WITHDRAW_DEPOSIT(106,"冻结提现金额"),
	FREEZE_SALE(107,"冻结货款"),FREEZE_SETTLEMENT_FEE(108,"冻结提现手续费"),FREEZE_SETTLEMENT_MER(109, "冻结子钱包提现金额"),
	FREEZE_SETTLEMENT_MER_FEE(110,"冻结提现手续费"),FREEZE_TRANSFER_WITHDRAW_DEPOSIT(111,"冻结转账提现金额"),FREEZE_TRANSFER_DEPOSIT(112,"转账收入"),
	FREEZE_TRADE_DEPOSIT(113,"冻结交易平台保证金"),FREEZE_TRADE_PAYMENT_GOODS(114,"冻结交易平台货款"),
	FREEZE_OIL_DRIVER_TO_MERCHANT(115,"冻结司机余额给商户用于加油"),FREEZE_AUCTION_DEPOSIT(116,"冻结竞拍保证金"),
	FREEZE_GROUP_SIGN_UP_DEPOSIT(117,"集采集销的保证金冻结"),FREEZE_WALLET_CARD(118,"消费卡消费到钱包冻结"),FREEZE_MERCHANT_CARD(119,"消费卡消费到商户冻结"),
	FREEZE_ORDER_CHILD(120, "冻结提现金额-运费自动提现"),
	
	UNFREEZE(200,"解冻"),
	UNFREEZE_OWNER_DEPOSIT(201,"解冻货主保证金"),UNFREEZE_FREIGHT(202,"解冻货主运费"),UNFREEZE_DRIVER_DEPOSIT(203,"解冻司机保证金"),
	UNFREEZE_INSURANCE_FEE(204,"解冻货物担保"),UNFREEZE_PLATFORM_FEE(205,"解冻平台信息费"),UNFREEZE_WITHDRAW_DEPOSIT(206,"解冻提现金额"),
	UNFREEZE_SALE(207,"解冻货款"),UNFREEZE_SETTLEMENT_FEE(208,"解冻提现手续费"),UNFREEZE_SETTLEMENT_MER(209, "解冻子钱包提现金额"),
	UNFREEZE_SETTLEMENT_MER_FEE(210,"解冻提现手续费"),UNFREEZE_TRANSFER_DEPOSIT(212,"解冻转账收入"),
	UNFREEZE_TRADE_DEPOSIT(213,"解冻交易平台保证金"),UNFREEZE_TRADE_PAYMENT_GOODS(214,"解冻交易平台货款"),
	UNFREEZE_OIL_DRIVER_TO_MERCHANT(215,"解冻司机余额给商户用于加油"),UNFREEZE_AUCTION_DEPOSIT(216,"解冻竞拍保证金"),
	UNFREEZE_FREEZE_GROUP_SIGN_UP_DEPOSIT(217,"集采集销的保证金冻结解冻"),UNFREEZE_WALLET_CARD(218,"消费卡消费到钱包解冻"),UNFREEZE_MERCHANT_CARD(219,"消费卡消费到商户解冻"),

	FREEZE_PAY(300,"从冻结支付"),
	FREEZE_PAY_OWNER_DEPOSIT(301,"支付货主保证金"),FREEZE_PAY_FREIGHT(302,"支付货物运费"),
	FREEZE_PAY_DRIVER_DEPOSIT(303,"支付司机保证金"),FREEZE_PAY_INSURANCE_FEE(304,"支付货物担保"),
	FREEZE_PAY_PLATFORM_FEE(305,"支付平台信息费"),FREEZE_PAY_WITHDRAW_DEPOSIT(306,"支付提现金额"),
	FREEZE_PAY_SALE(307,"支付货款"),FREEZE_PAY_SETTLEMENT_FEE(308,"支付提现手续费"),
	FREEZE_PAY_SETTLEMENT_MER(309, "支付子钱包提现金额"),FREEZE_PAY_SETTLEMENT_MER_FEE(310, "支付子钱包手续费"),
	FREEZE_PAY_TRANSFER_WITHDRAW_DEPOSIT(311,"支付余额转账提现金额"),FREEZE_PAY_TRANSFER_DEPOSIT(312,"支付转账收入"),
	FREEZE_PAY_TRADE_DEPOSIT(313,"保证金冻结"),FREEZE_PAY_TRADE_PAYMENT_GOODS(314,"货款扣款"),
	FREEZE_PAY_OIL_DRIVER_TO_MERCHANT(315,"消费"),FREEZE_PAY_AUCTION_DEPOSIT(316,"竞拍保证金冻结"),
	FREEZE_PAY_GROUP_SIGN_UP_DEPOSIT(317,"集采集销的保证金冻结"),FREEZE_PAY_WALLET_CARD(318,"消费"),FREEZE_PAY_MERCHANT_CARD(319,"消费"),
	FREEZE_PAY_ORDER_CHILD(320, "自动支付提现金额"),

	FREEZE_MODIFY(400,"修正冻结资金"),
	FREEZE_MODIFY_OWNER_DEPOSIT(401,"修正货主保证金"),FREEZE_MODIFY_FREIGHT(402,"修正货主运费"),
	FREEZE_MODIFY_DRIVER_DEPOSIT(403,"修正司机保证金"),FREEZE_MODIFY_INSURANCE_FEE(404,"修正货物担保"),
	FREEZE_MODIFY_PLATFORM_FEE(405,"修正平台信息费"),FREEZE_MODIFY_WITHDRAW_DEPOSIT(406,"修正提现金额"),
	FREEZE_MODIFY_SALE(407,"修正货款"),FREEZE_MODIFY_SETTLEMENT_FEE(408,"修正提现手续费"),
	FREEZE_MODIFY_SETTLEMENT_MER(409, "修正子钱包提现金额"),	FREEZE_MODIFY_SETTLEMENT_MER_FEE(410, "修正子钱包提现手续费"),
	FREEZE_MODIFY_TRANSFER_DEPOSIT(412,"修正转账收入"),FREEZE_MODIFY_TRADE_PAYMENT_GOODS(414,"修正交易平台冻结货款"),
	
	RESIDUE_PAY(500,"余额支付"),RESIDUE_ACTIVITY_RETURN(502,"余额活动返现"),RESIDUE_ACTIVITY_RETURN_CARD(503,"余额活动返现到消费卡"),
	/** 支付违约金 */
	RESIDUE_PAY_DEFAULT(501,"支付违约金"),
	
	CARD_PAY(600,"消费卡支付到钱包"),CARD_PAY_WALLET(601,"消费卡支付到子钱包"),
	SYSTEM_PAY(701, "系统支付到用户余额"),SYSTEM_PAY_CARD(702, "系统支付到用户消费卡"),SYSTEM_ACTIVITY_PAY(703, "系统活动返现到余额"),


	;
	// 成员变量
	private String msg;
	private int code;

	// 构造方法
	private PayUnitTypeEnum(int code, String msg) {
		this.msg = msg;
		this.code = code;
	}

	// 普通方法
	public static String getMsg(int code) {
		for (PayUnitTypeEnum c : PayUnitTypeEnum.values()) {
			if (c.getCode() == code) {
				return c.msg;
			}
		}
		return null;
	}
	
	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}

	public int getCode() {
		return code;
	}

	public void setCode(int code) {
		this.code = code;
	}
}
