package com.clx.performance.encryption.oldmsl;


import com.clx.performance.param.pc.payment.FreezeUnitDTO;
import com.clx.performance.param.pc.payment.PayUnitDTO;

import java.util.List;

/**
 * 
 * @author xujianke
 * @date 2017年4月18日
 * @description
 */
public class PayEncryptTools {
	/**
	 * 生成签名,签名结果直接赋值到PayUnitDTO签名字段
	 * @param
	 * @param privateKeyBytes
	 * @return 签名是否成功
	 */
	public static boolean sign(PayUnitDTO payDTO, byte[] privateKeyBytes){
		if(payDTO == null ){//参数错误
			return false;
		}
		byte[] data=makeByte(payDTO);
		String sign = RSACoder.sign(data, privateKeyBytes);
		if(sign == null){//签名失败
			return false;
		}
		payDTO.setSignature(sign);
		return true;
	}
	
	/**
	 * 生成签名,签名结果直接赋值到FreezeUnitDTO签名字段
	 * @param freezeDTO
	 * @param privateKeyBytes
	 * @return 签名是否成功
	 */
	public static boolean sign(FreezeUnitDTO freezeDTO, byte[] privateKeyBytes){
		if(freezeDTO == null ){//参数错误
			return false;
		}
		byte[] data=makeByte(freezeDTO);
		String sign = RSACoder.sign(data, privateKeyBytes);
		if(sign == null){//签名失败
			return false;
		}
		freezeDTO.setSignature(sign);
		return true;
	}
	/**
	 * 验证签名
	 * @param payDTO
	 * @param publicKeyBytes
	 * @return
	 */
	public static boolean verify(PayUnitDTO payDTO, byte[] publicKeyBytes){
		if(payDTO == null || payDTO.getSignature() == null){
			//参数错误
			return false;
		}
		byte[] data=makeByte(payDTO);
		return RSACoder.verify(data, publicKeyBytes, payDTO.getSignature());
	}
	/**
	 * 验证签名
	 * @param freezeDTO
	 * @param publicKeyBytes
	 * @return
	 */
	public static boolean verify(FreezeUnitDTO freezeDTO, byte[] publicKeyBytes){
		if(freezeDTO == null || freezeDTO.getSignature() == null){
			//参数错误
			return false;
		}
		byte[] data=makeByte(freezeDTO);
		return RSACoder.verify(data, publicKeyBytes, freezeDTO.getSignature());
	}
	/**
	 * 组装需要签名的字符串
	 * @param payDTO
	 * @return 字符串的字节数组
	 */
	public static byte[] makeByte(PayUnitDTO payDTO){
		StringBuilder sb = new StringBuilder();
		sb.append(payDTO.getFigure());
		sb.append(':').append(payDTO.getId());
		sb.append(':').append(payDTO.getFrom());
		sb.append(':').append(payDTO.getTimestamp());
		sb.append(':').append(payDTO.getTo());
		sb.append(':').append(payDTO.getType());
		String text = sb.toString();
		return text.getBytes();
	}
	/**
	 * 组装需要签名的字符串
	 * @param freezeDTO
	 * @return 字符串的字节数组
	 */
	public static byte[] makeByte(FreezeUnitDTO freezeDTO){
		StringBuilder sb = new StringBuilder();
		sb.append(freezeDTO.getAction());
		sb.append(':').append(freezeDTO.getFigure());
		sb.append(':').append(freezeDTO.getFee());
		sb.append(':').append(freezeDTO.getFeeType());
		sb.append(':').append(freezeDTO.getFreezeNo());
		sb.append(':').append(freezeDTO.getTimestamp());
		if(freezeDTO.getReturnFee() != null){
			sb.append(':').append(freezeDTO.getReturnFee());
		}
		String text = sb.toString();
		return text.getBytes();
	}
	/**
	 * 批量签名
	 * @param privateKeyBytes
	 * @return 成功签名的个数
	 */
	public static int signBatch(List<PayUnitDTO> list, byte[] privateKeyBytes){
		int count = 0;
		boolean b;
		for(PayUnitDTO payDTO:list){
			b = sign(payDTO, privateKeyBytes);
			if(b){
				count++;
			}
		}
		return count;
	}
	/**
	 * 批量验证签名
	 * @param publicKeyBytes
	 * @return
	 */
	public static int verifyBatch(List<PayUnitDTO> list, byte[] publicKeyBytes){
		boolean ret = true;
		int i;
		PayUnitDTO payDTO;
		for(i= 0; i<list.size();i++){
			payDTO = list.get(i);
			ret = verify(payDTO,publicKeyBytes);
			if(!ret){
				break;
			}
		}
		return i;
	}
}
