package com.clx.performance.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.OrderGoodsLogDao;
import com.clx.performance.mapper.OrderGoodsLogMapper;
import com.clx.performance.model.OrderGoodsLog;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

/**
 * @author kavin
 * Date 2023-10-26
 * Time 11:27
 */
@Repository
public class OrderGoodsLogDaoImpl extends BaseDaoImpl<OrderGoodsLogMapper, OrderGoodsLog, Integer> implements OrderGoodsLogDao {
    @Override
    public Page<OrderGoodsLog> pageOrderGoodsLog(Page page, String orderGoodsNo) {
        LambdaQueryWrapper<OrderGoodsLog> query = new LambdaQueryWrapper();
        query.eq(OrderGoodsLog :: getOrderGoodsNo,orderGoodsNo);
        query.orderByDesc(OrderGoodsLog :: getCreateTime);
        return baseMapper.selectPage(page,query);
    }
}
