package com.clx.performance.dao.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.IntegralOrderDao;
import com.clx.performance.mapper.IntegralOrderMapper;
import com.clx.performance.model.IntegralOrder;
import com.clx.performance.param.pc.pageIntegralOrderParam;
import com.clx.performance.vo.pc.IntegralOrderVO;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @Author: aiqinguo
 * @Description: 积分货单
 * @Date: 2023-10-9 12:00:54
 * @Version: 1.0
 */
@Repository
public class IntegralOrderDaoImpl extends BaseDaoImpl<IntegralOrderMapper, IntegralOrder, Integer> implements IntegralOrderDao {

    @Override
    public boolean existByOrderGoodsNo(String orderGoodsNo) {
        return baseMapper.existByOrderGoodsNo(orderGoodsNo)>0;

    }

    @Override
    public IPage<IntegralOrderVO> pageByParam(pageIntegralOrderParam param) {
        return baseMapper.pageByParam(Page.of(param.getPage(), param.getPageSize()), param);

    }

    @Override
    public List<String> getAllOrderNoList() {
        return baseMapper.getAllOrderNoList();
    }

    @Override
    public Optional<IntegralOrder> getByOrderGoodsNo(String orderGoodsNo) {
        return Optional.of(orderGoodsNo)
                .map(item -> lQrWrapper()
                        .eq(IntegralOrder::getOrderGoodsNo, item)
                )
                .map(super::getOne);
    }

}
