package com.clx.performance.dao;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.mapper.IntegralTruckMapper;
import com.clx.performance.model.IntegralTruck;
import com.clx.performance.param.app.integral.DriverPageIntegralTruckRankParam;
import com.clx.performance.param.pc.PageIntegralTruckRankParam;
import com.clx.performance.param.pc.PageIntegralTruckParam;
import com.clx.performance.vo.pc.IntegralTruckVO;
import com.msl.common.base.Optional;
import com.msl.common.dao.BaseDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Author: aiqinguo
 * @Description: 积分车辆
 * @Date: 2023-10-9 11:55:36
 * @Version: 1.0
 */
public interface IntegralTruckDao extends BaseDao<IntegralTruckMapper, IntegralTruck, Integer> {

    boolean updateIntegral(IntegralTruck item);
    boolean updateIntegralByTruckNo(String truckNo, Integer integral);

    boolean existByTruckNo(@Param("truckNo")String truckNo);

    IPage<IntegralTruckVO> pageByParam(PageIntegralTruckParam param);

    long countByTruckEchelon(@Param("truckEchelon")Integer truckEchelon);

    Optional<IntegralTruck> getByTruckNo(@Param("truckNo")String truckNo);

    List<IntegralTruck> listByTruckNoList(@Param("truckNoList") List<String> truckNoList);

    IPage<IntegralTruckVO> pageTruckRank(PageIntegralTruckRankParam param);
    IPage<IntegralTruckVO> driverPageTruckRank(DriverPageIntegralTruckRankParam param);

    List<IntegralTruck> selectListByTime(@Param("beginTime") String beginTime, @Param("endTime") String endTime);

}
