package com.clx.performance.param.pc.payment;


import lombok.*;
import lombok.experimental.Accessors;

@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Accessors(chain = true)
public class PayUserDTO {
	/**用户钱包编号 用户发起的操作必填 */
	private Integer userCode;
	/** 交易密码 用户发起的操作必填 */
	private String pwd;
	/** 支付单元 */
	PayUnitDTO payUnitDTO;
	/** 平台服务续费 **/
	private Integer fee = 0;
	/** 平台服务续费的去向 **/
	private Integer feeToUserCode = 10000;

	/** 业务系统编码  参考<SystemCodeEnum> */
	private Integer system;
	/** 支付结果通知回调地址 */
	private String notifyUrl;
	/** 操作唯一标识 UUID */
	private String uuid;
	/** 关联单号 */
	private String orderNo;
}
