package com.clx.performance.param.mq;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * @Author: aiqingguo
 * @Description: 积分货单新增
 * @Date: 2023-10-13 11:02:01
 * @Version: 1.0
 */
@Setter
@Getter
@ToString
@NoArgsConstructor
public class IntegralOrderAddMqParam {

    @ApiModelProperty(value = "货单编号", example = "1000000000000")
    private String orderGoodsNo;
    @ApiModelProperty(value = "发货地址id", example = "1")
    private Integer sendAddressId;
    @ApiModelProperty(value = "发货地址", example = "北京")
    private String sendAddress;
    @ApiModelProperty(value = "收货地址id", example = "2")
    private Integer receiveAddressId;
    @ApiModelProperty(value = "收货地址", example = "上海")
    private String receiveAddress;
    @ApiModelProperty(value = "货单类型：1优质单 2普通单 3流水单 4支援单", example = "上海")
    private Integer orderType;

}
