package com.clx.performance.feign;

import com.msl.common.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;

@FeignClient(name = "msl-document",configuration = PerformanceClientConfiguration.class)
public interface DocumentFeign {

    /**
     * 获取用户协议
     *
     * @param agreementNo
     * @return
     */
    @RequestMapping(method = {RequestMethod.GET}, value = {"/msl-document/agreement/getCurrentUserVersion"})
    String getCurrentUserVersion(@RequestParam("agreementNo") @NotBlank(message = "编号不可为空") String agreementNo);

    /**
     * @Author kavin
     * @Description 获取oss的domain
     * @Param []
     * @return
     **/
    @GetMapping({"/msl-document/fileUpload/getHost"})
    Result<String> getHost();

}
