package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public enum CancelOrderEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum Type {

        NOT_CHILD(1, "违约无运单"),
        NOT_TRANSPORTED(2, "取消未拉运吨数"),
        NOT_ARRIVE(3, "取消未到达货源地"),
        ;

        private final Integer code;
        private final String name;

        public static Optional<Type> getByCode(Integer code) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.getCode(), code)).findFirst();
        }
    }


}
