package com.clx.performance.sqlProvider;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.param.pc.pageIntegralStatisticsDetailParam;
import com.clx.performance.vo.pc.IntegralRecordVO;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

public class IntegralRecordSqlProvider {

    public String pageByParam(@Param("page") Page<IntegralRecordVO> page, @Param("param") pageIntegralStatisticsDetailParam param) {
        return new SQL(){{

            SELECT( " id, truck_no as truckNo, " +
                    " statistics_id as statisticsId, statistics_date as statisticsDate, " +
                    " integral, type, remark, " +
                    " date_format(create_time, '%Y-%m-%d %H:%i:%s') as createTime, " +
                    " date_format(modified_time, '%Y-%m-%d %H:%i:%s') as modifiedTime ");

            FROM("integral_record");

            WHERE("statistics_id = #{param.statisticsId}");

            ORDER_BY("create_time desc");
        }}.toString();
    }

}
