package com.clx.performance.service.impl.settle;

import com.clx.performance.dao.settle.SettlementLogDao;
import com.clx.performance.model.settle.SettlementLog;
import com.clx.performance.service.settle.SettlementLogService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author liruixin
 * Date 2023-10-12
 * Time 09:43
 */
@Slf4j
@Service
@AllArgsConstructor
public class SettlementLogServiceImpl  implements SettlementLogService {

    @Autowired
    private final SettlementLogDao settlementLogDao;


    @Override
    public void saveSettlementLog(String settlementNo, Integer type, String remark, Integer createType, Long createBy, String createName) {

        SettlementLog settlementLog = new SettlementLog();
        settlementLog.setSettlementNo(settlementNo);
        settlementLog.setType(type);
        settlementLog.setRemark(remark);
        settlementLog.setCreateType(createType);
        settlementLog.setCreateBy(createBy);
        settlementLog.setCreateName(createName);

        settlementLogDao.saveEntity(settlementLog);
    }
}
