package com.clx.performance.service.impl.settle;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.settle.SettlementDriverDao;
import com.clx.performance.model.settle.SettlementDriver;
import com.clx.performance.param.pc.driver.PageCarrierSettlementDriverParam;
import com.clx.performance.service.settle.SettlementDriverService;
import com.clx.performance.struct.settle.SettlementDriverStruct;
import com.clx.performance.vo.pc.carrier.settle.CarrierPageSettlementDriverVO;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author liruixin
 * Date 2023-10-12
 * Time 09:43
 */
@Service
@AllArgsConstructor
public class SettlementDriverServiceImpl implements SettlementDriverService {


    SettlementDriverDao settlementDriverDao;
    SettlementDriverStruct settlementDriverStruct;


    @Override
    public IPage<CarrierPageSettlementDriverVO> pageCarrierSettlementDriver(PageCarrierSettlementDriverParam param) {
        IPage<SettlementDriver> page = settlementDriverDao.pageCarrierSettlementDriver(param);
        List<CarrierPageSettlementDriverVO> list = settlementDriverStruct.covertList(
                page.getRecords());
        return new Page<CarrierPageSettlementDriverVO>().setRecords(list).setTotal(page.getTotal()).setPages(page.getPages());
    }
}
