package com.clx.performance.service.impl.breakcontract;


import com.alibaba.fastjson.JSON;
import com.clx.performance.dao.breakcontract.BreakContractDriverRuleDao;
import com.clx.performance.model.breakcontract.BreakContractDriverRule;
import com.clx.performance.param.pc.breakcontract.carrier.BreakContractDriveRuleUpdateParam;
import com.clx.performance.service.breakcontract.BreakContractDriverRuleService;
import com.clx.performance.vo.pc.breakcontract.carrier.BreakContractDriverRuleVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
@Service
public class BreakContractDriverRuleServiceImpl  implements BreakContractDriverRuleService {

    @Autowired
    private BreakContractDriverRuleDao breakContractDriverRuleDao;

    @Override
    public void updateRule(BreakContractDriveRuleUpdateParam param) {

        BreakContractDriverRule rule = breakContractDriverRuleDao.getEntityByKey(1).orNull();
        if (rule == null){
            rule = new BreakContractDriverRule();
            rule.setId(1);
            rule.setRuleJson(JSON.toJSONString(param));
            breakContractDriverRuleDao.saveEntity(rule);
        }
        else {
            rule.setRuleJson(JSON.toJSONString(param));
            breakContractDriverRuleDao.updateRule(rule);
        }
    }

    @Override
    public BreakContractDriverRuleVO getRuleInfo() {

        BreakContractDriverRule rule = breakContractDriverRuleDao.getEntityByKey(1).orNull();

        BreakContractDriverRuleVO vo;
        if (rule != null){
            vo = JSON.parseObject(rule.getRuleJson(), BreakContractDriverRuleVO.class);
        }
        else {
            vo = new BreakContractDriverRuleVO();
            vo.setDriverCancelRule(new BreakContractDriverRuleVO.DriverCancelRule());
            vo.setSendAddressRule(new BreakContractDriverRuleVO.SendAddressRule());
            vo.setReceiveAddressRule(new BreakContractDriverRuleVO.ReceiveAddressRule());
        }
        return vo;
    }
}
