package com.clx.performance.model.integral;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
* @Author: aiqinguo
* @Description: 车辆积分规则
* @Date: 2023/11/06 14:12:53
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
@TableName(autoResultMap = true)
public class IntegralTruckRule implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;                             //id
    private String name;                            //层级名称
    private Integer integralRatioBegin;             //积分起始范围
    private Integer integralRatioEnd;               //积分结束范围
    private Integer status;                         //状态：1开启 2关闭
    private BigDecimal incomeBegin;                 //预期收益开始范围（分）
    private BigDecimal incomeEnd;                   //预期收益结束范围（分）
    private LocalDateTime createTime;               //创建时间
    private LocalDateTime modifiedTime;             //修改时间

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }

}