package com.clx.performance.listener.child;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.clx.performance.common.MqDelay;
import com.clx.performance.common.MqWrapper;
import com.clx.performance.constant.RabbitKeyOrderChildConstants;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilder;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @Author: 艾庆国
 * @Description: 运单 mq
 * @Date: 2023-10-20 10:30:49
 * @Version: 1.0
 */
@Slf4j
@Component
public class OrderChildDelayListener {
    @Autowired
    private RabbitTemplate rabbitTemplate;

    @RabbitListener(queues = RabbitKeyOrderChildConstants.DEFAULT_DEAD_QUEUE)
    public void process(Message message) {
        try{
            log.info("运单-延迟, message:{}", message);
            process(JSON.parseObject(new String(message.getBody()), new TypeReference<MqWrapper<MqDelay>>(){}).getData());
        }catch (Exception e){
            log.info("运单-延迟 失败",e);
        }
    }

    void process(MqDelay mq){
        Message message = MessageBuilder.withBody(JSON.toJSONString(mq.getData()).getBytes()).build();
        rabbitTemplate.send(mq.getExchange(), mq.getRouterKey(), message);
    }

}
